/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.netty.udp.impl;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramPacket;
import io.netty.util.AttributeKey;
import org.noear.socketd.transport.core.ChannelInternal;
import org.noear.socketd.transport.core.ChannelSupporter;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.impl.ChannelDefault;
import org.noear.socketd.transport.netty.udp.UdpNioChannelAssistant;
import org.noear.socketd.transport.netty.udp.UdpNioServer;
import org.noear.socketd.transport.netty.udp.impl.DatagramTagert;

@ChannelHandler.Sharable
public class NettyServerInboundHandler
extends SimpleChannelInboundHandler<DatagramPacket> {
    private static AttributeKey<ChannelInternal> CHANNEL_KEY = AttributeKey.valueOf((String)"CHANNEL_KEY");
    private UdpNioServer server;

    public NettyServerInboundHandler(UdpNioServer server) {
        this.server = server;
    }

    protected void channelRead0(ChannelHandlerContext ctx, DatagramPacket packet) throws Exception {
        Frame frame;
        ChannelInternal channel = (ChannelInternal)ctx.attr(CHANNEL_KEY).get();
        if (channel == null) {
            DatagramTagert tagert = new DatagramTagert(ctx.channel(), packet, false);
            channel = new ChannelDefault((Object)tagert, (ChannelSupporter)this.server);
            ctx.attr(CHANNEL_KEY).set((Object)channel);
        }
        if ((frame = ((UdpNioChannelAssistant)this.server.getAssistant()).read((ByteBuf)packet.content())) != null) {
            this.server.getProcessor().onReceive(channel, frame);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ChannelInternal channel = (ChannelInternal)ctx.attr(CHANNEL_KEY).get();
        this.server.getProcessor().onError(channel, cause);
    }
}

