/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.netty.tcp;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.io.IOException;
import java.util.concurrent.ThreadFactory;
import org.noear.socketd.SocketD;
import org.noear.socketd.exception.SocketdException;
import org.noear.socketd.transport.core.ChannelAssistant;
import org.noear.socketd.transport.core.ChannelSupporter;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.netty.tcp.TcpNioChannelAssistant;
import org.noear.socketd.transport.netty.tcp.impl.NettyChannelInitializer;
import org.noear.socketd.transport.netty.tcp.impl.NettyServerInboundHandler;
import org.noear.socketd.transport.server.Server;
import org.noear.socketd.transport.server.ServerBase;
import org.noear.socketd.transport.server.ServerConfig;
import org.noear.socketd.utils.NamedThreadFactory;
import org.noear.socketd.utils.StrUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpNioServer
extends ServerBase<TcpNioChannelAssistant>
implements ChannelSupporter<Channel> {
    private static final Logger log = LoggerFactory.getLogger(TcpNioServer.class);
    private ChannelFuture server;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workGroup;

    public TcpNioServer(ServerConfig config) {
        super(config, (ChannelAssistant)new TcpNioChannelAssistant());
    }

    public String getTitle() {
        return "tcp/nio/netty 4.1/" + SocketD.version();
    }

    public Server start() throws IOException {
        if (this.isStarted) {
            throw new IllegalStateException("Socket.D server started");
        }
        this.isStarted = true;
        this.bossGroup = new NioEventLoopGroup(2, (ThreadFactory)new NamedThreadFactory("nettyTcpServerBoss-"));
        this.workGroup = new NioEventLoopGroup(this.getConfig().getCoreThreads(), (ThreadFactory)new NamedThreadFactory("nettyTcpServerWork-"));
        try {
            NettyServerInboundHandler inboundHandler = new NettyServerInboundHandler(this);
            NettyChannelInitializer channelHandler = new NettyChannelInitializer((Config)this.getConfig(), inboundHandler);
            ServerBootstrap bootstrap = new ServerBootstrap();
            ((ServerBootstrap)bootstrap.group(this.bossGroup, this.workGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)channelHandler);
            this.server = StrUtils.isEmpty((String)this.getConfig().getHost()) ? bootstrap.bind(this.getConfig().getPort()).await() : bootstrap.bind(this.getConfig().getHost(), this.getConfig().getPort()).await();
        }
        catch (Exception e) {
            this.bossGroup.shutdownGracefully();
            this.workGroup.shutdownGracefully();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new SocketdException("Socket.D server start failed!", (Throwable)e);
        }
        log.info("Socket.D server started: {server=" + this.getConfig().getLocalUrl() + "}");
        return this;
    }

    public void stop() {
        block6: {
            if (!this.isStarted) {
                return;
            }
            this.isStarted = false;
            try {
                if (this.server != null) {
                    this.server.channel().close();
                }
                if (this.bossGroup != null) {
                    this.bossGroup.shutdownGracefully();
                }
                if (this.workGroup != null) {
                    this.workGroup.shutdownGracefully();
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block6;
                log.debug("Server stop error", (Throwable)e);
            }
        }
    }
}

