/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.netty.tcp.impl;

import io.netty.buffer.ByteBuf;
import org.noear.socketd.transport.core.CodecReader;

public class NettyBufferCodecReader
implements CodecReader {
    private ByteBuf source;

    public NettyBufferCodecReader(ByteBuf source) {
        this.source = source;
    }

    public byte getByte() {
        return this.source.readByte();
    }

    public void getBytes(byte[] dst, int offset, int length) {
        this.source.readBytes(dst, offset, length);
    }

    public int getInt() {
        return this.source.readInt();
    }

    public byte peekByte() {
        if (this.source.readableBytes() > 0) {
            return this.source.getByte(this.source.readerIndex());
        }
        return -1;
    }

    public void skipBytes(int length) {
        this.source.skipBytes(length);
    }

    public int remaining() {
        return this.source.readableBytes();
    }

    public int position() {
        return this.source.readerIndex();
    }
}

