/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.netty.udp;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import java.io.IOException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.noear.socketd.exception.SocketdConnectionException;
import org.noear.socketd.exception.SocketdTimeoutException;
import org.noear.socketd.transport.client.ClientConnectorBase;
import org.noear.socketd.transport.client.ClientHandshakeResult;
import org.noear.socketd.transport.client.ClientInternal;
import org.noear.socketd.transport.core.ChannelInternal;
import org.noear.socketd.transport.netty.udp.UdpNioClient;
import org.noear.socketd.transport.netty.udp.impl.NettyClientInboundHandler;
import org.noear.socketd.utils.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpNioClientConnector
extends ClientConnectorBase<UdpNioClient> {
    private static final Logger log = LoggerFactory.getLogger(UdpNioClientConnector.class);
    private ChannelFuture real;
    private NioEventLoopGroup workerGroup;

    public UdpNioClientConnector(UdpNioClient client) {
        super((ClientInternal)client);
    }

    public ChannelInternal connect() throws IOException {
        this.close();
        this.workerGroup = new NioEventLoopGroup(2, (ThreadFactory)new NamedThreadFactory("nettyUdpClientWork-"));
        try {
            Bootstrap bootstrap = new Bootstrap();
            NettyClientInboundHandler inboundHandler = new NettyClientInboundHandler((UdpNioClient)this.client);
            this.real = ((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)this.workerGroup)).channel(NioDatagramChannel.class)).handler((ChannelHandler)inboundHandler)).connect(((UdpNioClient)this.client).getConfig().getHost(), ((UdpNioClient)this.client).getConfig().getPort()).await();
            ClientHandshakeResult handshakeResult = inboundHandler.getHandshakeFuture().get(((UdpNioClient)this.client).getConfig().getConnectTimeout(), TimeUnit.MILLISECONDS);
            if (handshakeResult.getThrowable() != null) {
                throw handshakeResult.getThrowable();
            }
            return handshakeResult.getChannel();
        }
        catch (TimeoutException e) {
            this.close();
            throw new SocketdTimeoutException("Connection timeout: " + ((UdpNioClient)this.client).getConfig().getLinkUrl());
        }
        catch (Throwable e) {
            this.close();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new SocketdConnectionException("Connection failed: " + ((UdpNioClient)this.client).getConfig().getLinkUrl(), e);
        }
    }

    public void close() {
        try {
            if (this.real != null) {
                this.real.channel().close();
            }
            if (this.workerGroup != null) {
                this.workerGroup.shutdownGracefully();
            }
        }
        catch (Throwable e) {
            log.debug("{}", e);
        }
    }
}

