/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.netty.udp;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import java.io.IOException;
import java.util.concurrent.ThreadFactory;
import org.noear.socketd.SocketD;
import org.noear.socketd.exception.SocketdException;
import org.noear.socketd.transport.core.ChannelAssistant;
import org.noear.socketd.transport.core.ChannelSupporter;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.netty.udp.UdpNioChannelAssistant;
import org.noear.socketd.transport.netty.udp.impl.DatagramTagert;
import org.noear.socketd.transport.netty.udp.impl.NettyServerInboundHandler;
import org.noear.socketd.transport.server.Server;
import org.noear.socketd.transport.server.ServerBase;
import org.noear.socketd.transport.server.ServerConfig;
import org.noear.socketd.utils.NamedThreadFactory;
import org.noear.socketd.utils.StrUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpNioServer
extends ServerBase<UdpNioChannelAssistant>
implements ChannelSupporter<DatagramTagert> {
    private static final Logger log = LoggerFactory.getLogger(UdpNioServer.class);
    private ChannelFuture server;
    private EventLoopGroup bossGroup;

    public UdpNioServer(ServerConfig config) {
        super(config, (ChannelAssistant)new UdpNioChannelAssistant((Config)config));
    }

    public String getTitle() {
        return "udp/nio/netty 4.1/" + SocketD.version();
    }

    public Server start() throws IOException {
        if (this.isStarted) {
            throw new IllegalStateException("Socket.D server started");
        }
        this.isStarted = true;
        this.bossGroup = new NioEventLoopGroup(2, (ThreadFactory)new NamedThreadFactory("nettyUdpServerBoss-"));
        try {
            NettyServerInboundHandler inboundHandler = new NettyServerInboundHandler(this);
            Bootstrap bootstrap = new Bootstrap();
            ((Bootstrap)((Bootstrap)bootstrap.group(this.bossGroup)).channel(NioDatagramChannel.class)).handler((ChannelHandler)inboundHandler);
            this.server = StrUtils.isEmpty((String)this.getConfig().getHost()) ? bootstrap.bind(this.getConfig().getPort()).await() : bootstrap.bind(this.getConfig().getHost(), this.getConfig().getPort()).await();
        }
        catch (Exception e) {
            this.bossGroup.shutdownGracefully();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new SocketdException("Socket.D server start failed!", (Throwable)e);
        }
        log.info("Socket.D server started: {server=" + this.getConfig().getLocalUrl() + "}");
        return this;
    }

    public void stop() {
        if (!this.isStarted) {
            return;
        }
        this.isStarted = false;
        try {
            if (this.server != null) {
                this.server.channel().close();
            }
            if (this.bossGroup != null) {
                this.bossGroup.shutdownGracefully();
            }
        }
        catch (Exception e) {
            log.debug("{}", (Throwable)e);
        }
    }
}

