/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.netty.udp.impl;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.socket.DatagramPacket;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;

public class DatagramTagert
implements Closeable {
    private final boolean isClient;
    private final Channel socket;
    private final DatagramPacket packet;

    public DatagramTagert(Channel socket, DatagramPacket packet, boolean isClient) {
        this.socket = socket;
        this.packet = packet;
        this.isClient = isClient;
    }

    public void send(byte[] bytes) throws IOException {
        if (this.isClient) {
            this.socket.writeAndFlush((Object)new DatagramPacket(Unpooled.copiedBuffer((byte[])bytes), (InetSocketAddress)this.socket.remoteAddress()));
        } else {
            this.socket.writeAndFlush((Object)new DatagramPacket(Unpooled.copiedBuffer((byte[])bytes), (InetSocketAddress)this.packet.sender()));
        }
    }

    public InetSocketAddress getRemoteAddress() {
        if (this.isClient) {
            return (InetSocketAddress)this.socket.remoteAddress();
        }
        return (InetSocketAddress)this.packet.sender();
    }

    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.socket.localAddress();
    }

    @Override
    public void close() throws IOException {
        if (this.isClient) {
            this.socket.close();
        }
    }
}

