/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jlhttp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.noear.jlhttp.HTTPServer;
import org.noear.solon.Utils;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.io.LimitedInputStream;
import org.noear.solon.boot.jlhttp.MultipartUtil;
import org.noear.solon.boot.web.AsyncContextState;
import org.noear.solon.boot.web.DecodeUtils;
import org.noear.solon.boot.web.RedirectUtils;
import org.noear.solon.boot.web.WebContextBase;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ContextAsyncListener;
import org.noear.solon.core.handle.Cookie;
import org.noear.solon.core.handle.UploadedFile;
import org.noear.solon.core.util.IoUtil;
import org.noear.solon.core.util.MultiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JlHttpContext
extends WebContextBase {
    static final Logger log = LoggerFactory.getLogger(JlHttpContext.class);
    private HTTPServer.Request _request;
    private HTTPServer.Response _response;
    private boolean _loadMultipartFormData = false;
    private URI _uri;
    private String _url;
    private long contentLength = -2L;
    private InputStream bodyAsStream;
    private MultiMap<String> _paramMap;
    private MultiMap<String> _cookieMap;
    private MultiMap<String> _headerMap;
    private ByteArrayOutputStream _outputStreamTmp;
    private int _status = 200;
    private boolean _allows_write = true;
    private AsyncContextState asyncState = new AsyncContextState();

    public JlHttpContext(HTTPServer.Request request, HTTPServer.Response response) {
        this._request = request;
        this._response = response;
    }

    private void loadMultipartFormData() {
        if (this._loadMultipartFormData) {
            return;
        }
        this._loadMultipartFormData = true;
        if (this.isMultipartFormData()) {
            MultipartUtil.buildParamsAndFiles(this, (MultiMap<UploadedFile>)this._fileMap);
        }
    }

    public Object request() {
        return this._request;
    }

    public String remoteIp() {
        return this._request.getSocket().getInetAddress().getHostAddress();
    }

    public int remotePort() {
        return this._request.getSocket().getPort();
    }

    public String method() {
        return this._request.getMethod();
    }

    public String protocol() {
        return this._request.getVersion();
    }

    public URI uri() {
        if (this._uri == null) {
            this._uri = URI.create(this.url());
        }
        return this._uri;
    }

    public boolean isSecure() {
        return "https".equals(this.uri().getScheme());
    }

    public String url() {
        if (this._url == null) {
            this._url = this._request.getURI().toString();
            if (this._url != null) {
                int idx;
                if (this._url.startsWith("/")) {
                    String host = this.header("Host");
                    if (host == null) {
                        host = this.header(":authority");
                        String scheme = this.header(":scheme");
                        if (host == null) {
                            host = "localhost";
                        }
                        this._url = scheme != null ? "https://" + host + this._url : scheme + "://" + host + this._url;
                    } else {
                        this._url = "http://" + host + this._url;
                    }
                }
                if ((idx = this._url.indexOf("?")) > 0) {
                    this._url = this._url.substring(0, idx);
                }
            }
        }
        return this._url;
    }

    public long contentLength() {
        if (this.contentLength < -1L) {
            this.contentLength = DecodeUtils.decodeContentLengthLong((Context)this);
        }
        return this.contentLength;
    }

    public String queryString() {
        return this._request.getURI().getQuery();
    }

    public InputStream bodyAsStream() throws IOException {
        if (this.bodyAsStream == null) {
            this.bodyAsStream = new LimitedInputStream(this._request.getBody(), ServerProps.request_maxBodySize);
        }
        return this.bodyAsStream;
    }

    public String body(String charset) throws IOException {
        try {
            return super.body(charset);
        }
        catch (Exception e) {
            throw MultipartUtil.status4xx((Context)this, e);
        }
    }

    public MultiMap<String> paramMap() {
        this.paramsMapInit();
        return this._paramMap;
    }

    private void paramsMapInit() {
        if (this._paramMap == null) {
            this._paramMap = new MultiMap();
            try {
                if (this.autoMultipart()) {
                    this.loadMultipartFormData();
                }
                for (String[] kv : this._request.getParamsList()) {
                    this._paramMap.add(kv[0], (Object)kv[1]);
                }
            }
            catch (Exception e) {
                throw MultipartUtil.status4xx((Context)this, e);
            }
        }
    }

    public MultiMap<UploadedFile> fileMap() {
        if (this.isMultipartFormData()) {
            this.loadMultipartFormData();
        }
        return this._fileMap;
    }

    public MultiMap<String> cookieMap() {
        if (this._cookieMap == null) {
            this._cookieMap = new MultiMap();
            DecodeUtils.decodeCookies((Context)this, (String)this.header("Cookie"));
        }
        return this._cookieMap;
    }

    public MultiMap<String> headerMap() {
        if (this._headerMap == null) {
            this._headerMap = new MultiMap();
            HTTPServer.Headers headers = this._request.getHeaders();
            if (headers != null) {
                for (HTTPServer.Header h : headers) {
                    this._headerMap.add(h.getName(), (Object)h.getValue());
                }
            }
        }
        return this._headerMap;
    }

    public Object response() {
        return this._response;
    }

    protected void contentTypeDoSet(String contentType) {
        if (this.charset != null && contentType.indexOf(";") < 0) {
            this.headerSet("Content-Type", contentType + ";charset=" + this.charset);
            return;
        }
        this.headerSet("Content-Type", contentType);
    }

    public OutputStream outputStream() throws IOException {
        this.sendHeaders(false);
        if (this._allows_write) {
            return this._response.getBody();
        }
        if (this._outputStreamTmp == null) {
            this._outputStreamTmp = new ByteArrayOutputStream();
        } else {
            this._outputStreamTmp.reset();
        }
        return this._outputStreamTmp;
    }

    public void output(byte[] bytes) {
        try {
            OutputStream out = this.outputStream();
            if (!this._allows_write) {
                return;
            }
            out.write(bytes);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void output(InputStream stream) {
        try {
            OutputStream out = this.outputStream();
            if (!this._allows_write) {
                return;
            }
            IoUtil.transferTo((InputStream)stream, (OutputStream)out);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void headerSet(String key, String val) {
        this._response.getHeaders().replace(key, val);
    }

    public void headerAdd(String key, String val) {
        this._response.getHeaders().add(key, val);
    }

    public String headerOfResponse(String name) {
        return this._response.getHeaders().get(name);
    }

    public Collection<String> headerValuesOfResponse(String name) {
        ArrayList<String> values = new ArrayList<String>();
        for (HTTPServer.Header h1 : this._response.getHeaders()) {
            if (!h1.getName().equalsIgnoreCase(name)) continue;
            values.add(h1.getValue());
        }
        return values;
    }

    public Collection<String> headerNamesOfResponse() {
        HashSet<String> names = new HashSet<String>();
        for (HTTPServer.Header h1 : this._response.getHeaders()) {
            names.add(h1.getName());
        }
        return names;
    }

    public void cookieSet(Cookie cookie) {
        StringBuilder buf = new StringBuilder();
        buf.append(cookie.name).append("=").append(cookie.value).append(";");
        if (cookie.maxAge >= 0) {
            buf.append("max-age=").append(cookie.maxAge).append(";");
        }
        if (Utils.isNotEmpty((String)cookie.domain)) {
            buf.append("domain=").append(cookie.domain.toLowerCase()).append(";");
        }
        if (Utils.isNotEmpty((String)cookie.path)) {
            buf.append("path=").append(cookie.path).append(";");
        }
        if (cookie.secure) {
            buf.append("secure").append(";");
        }
        if (cookie.httpOnly) {
            buf.append("httponly").append(";");
        }
        this.headerAdd("Set-Cookie", buf.toString());
    }

    public void redirect(String url, int code) {
        url = RedirectUtils.getRedirectPath((String)url);
        this.headerSet("Location", url);
        this.statusDoSet(code);
    }

    public int status() {
        return this._status;
    }

    protected void statusDoSet(int status) {
        this._status = status;
    }

    public void flush() throws IOException {
        if (this._allows_write) {
            this.outputStream();
            this._response.flush();
        }
    }

    public void close() throws IOException {
        this._response.close();
    }

    protected void innerCommit() throws IOException {
        try {
            if (this.getHandled() || this.status() >= 200) {
                this.sendHeaders(true);
            } else if (!this._response.headersSent()) {
                this._response.sendError(404);
            }
        }
        finally {
            if (this.asyncState.asyncFuture != null) {
                this.asyncState.asyncFuture.complete(null);
            }
        }
    }

    private void sendHeaders(boolean isCommit) throws IOException {
        if (!this._response.headersSent()) {
            if ("HEAD".equals(this.method())) {
                this._allows_write = false;
            }
            if (this.sessionState() != null) {
                this.sessionState().sessionPublish();
            }
            if (isCommit || !this._allows_write) {
                this._response.sendHeaders(this.status(), 0L, -1L, null, null, null);
            } else {
                String tmp = this._response.getHeaders().get("Content-Length");
                if (tmp != null) {
                    this._response.sendHeaders(this.status(), Long.parseLong(tmp), -1L, null, null, null);
                } else {
                    this._response.sendHeaders(this.status(), -1L, -1L, null, null, null);
                }
            }
        }
    }

    public boolean asyncSupported() {
        return true;
    }

    public boolean asyncStarted() {
        return this.asyncState.isStarted;
    }

    public void asyncListener(ContextAsyncListener listener) {
        this.asyncState.addListener(listener);
    }

    public void asyncStart(long timeout, Runnable runnable) {
        if (!this.asyncState.isStarted) {
            this.asyncState.isStarted = true;
            this.asyncState.asyncFuture = new CompletableFuture();
            this.asyncState.asyncDelay(timeout, (Context)this, this::innerCommit);
            if (runnable != null) {
                runnable.run();
            }
            this.asyncState.onStart((Context)this);
        }
    }

    public void asyncComplete() {
        if (this.asyncState.isStarted) {
            try {
                this.innerCommit();
            }
            catch (Throwable e) {
                log.warn("Async completion failed", e);
                this.asyncState.onError((Context)this, e);
            }
            finally {
                this.asyncState.onComplete((Context)this);
            }
        }
    }

    protected void asyncAwait() throws InterruptedException, ExecutionException, IOException {
        if (this.asyncState.isStarted) {
            this.asyncState.asyncFuture.get();
        }
    }
}

