/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jlhttp;

import java.io.IOException;
import java.io.InputStream;
import org.noear.jlhttp.HTTPServer;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.http.HttpPartFile;
import org.noear.solon.boot.io.LimitedInputException;
import org.noear.solon.boot.io.LimitedInputStream;
import org.noear.solon.boot.jlhttp.JlHttpContext;
import org.noear.solon.core.exception.StatusException;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.UploadedFile;
import org.noear.solon.core.util.KeyValues;
import org.noear.solon.core.util.MultiMap;

class MultipartUtil {
    MultipartUtil() {
    }

    public static void buildParamsAndFiles(JlHttpContext ctx, MultiMap<UploadedFile> filesMap) {
        try {
            HTTPServer.Request request = (HTTPServer.Request)ctx.request();
            HTTPServer.MultipartIterator parts = new HTTPServer.MultipartIterator(request);
            while (parts.hasNext()) {
                HTTPServer.MultipartIterator.Part part = parts.next();
                String name = ServerProps.urlDecode((String)part.getName());
                if (MultipartUtil.isFile(part)) {
                    MultipartUtil.doBuildFiles(name, filesMap, part);
                    continue;
                }
                ctx.paramMap().add(name, (Object)part.getString());
            }
        }
        catch (Exception e) {
            throw MultipartUtil.status4xx((Context)ctx, e);
        }
    }

    public static StatusException status4xx(Context ctx, Exception e) {
        if (e instanceof StatusException) {
            return (StatusException)e;
        }
        if (MultipartUtil.isBodyLargerEx(e)) {
            return new StatusException("Request Entity Too Large: " + ctx.method() + " " + ctx.pathNew(), (Throwable)e, 413);
        }
        return new StatusException("Bad Request:" + ctx.method() + " " + ctx.pathNew(), (Throwable)e, 400);
    }

    private static void doBuildFiles(String name, MultiMap<UploadedFile> filesMap, HTTPServer.MultipartIterator.Part part) throws IOException {
        KeyValues list = filesMap.holder(name);
        String contentType = part.getHeaders().get("Content-Type");
        String filename = part.getFilename();
        String extension = null;
        int idx = filename.lastIndexOf(".");
        if (idx > 0) {
            extension = filename.substring(idx + 1);
        }
        HttpPartFile partFile = new HttpPartFile(filename, (InputStream)new LimitedInputStream(part.getBody(), ServerProps.request_maxFileSize));
        UploadedFile f1 = new UploadedFile(() -> ((HttpPartFile)partFile).delete(), contentType, partFile.getSize(), partFile.getContent(), filename, extension);
        list.addValue((Object)f1);
    }

    private static boolean isField(HTTPServer.MultipartIterator.Part filePart) {
        return filePart.getFilename() == null;
    }

    private static boolean isFile(HTTPServer.MultipartIterator.Part filePart) {
        return !MultipartUtil.isField(filePart);
    }

    public static boolean isBodyLargerEx(Throwable e) {
        return MultipartUtil.hasLargerStr(e) || MultipartUtil.hasLargerStr(e.getCause());
    }

    private static boolean hasLargerStr(Throwable e) {
        if (e instanceof LimitedInputException) {
            return true;
        }
        if (e == null || e.getMessage() == null) {
            return false;
        }
        return e.getMessage().contains("too large");
    }
}

