/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sql.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.noear.solon.data.sql.Row;
import org.noear.solon.data.sql.RowIterator;
import org.noear.solon.data.sql.RowList;
import org.noear.solon.data.sql.SqlExecutor;
import org.noear.solon.data.sql.impl.CommandHolder;
import org.noear.solon.data.sql.impl.SimpleRowIterator;
import org.noear.solon.data.sql.impl.SimpleRowList;
import org.noear.solon.data.sql.impl.SimpleSqlUtils;

public class SimpleSqlExecutor
implements SqlExecutor {
    private final SimpleSqlUtils utils;
    private final String sql;
    private final Object[] args;

    public SimpleSqlExecutor(SimpleSqlUtils utils, String sql, Object[] args) {
        this.utils = utils;
        this.sql = sql;
        this.args = args;
    }

    @Override
    public <T> T queryValue() throws SQLException {
        try (CommandHolder holder = this.utils.buildCommand(this.sql, this.args, false, false);){
            holder.rsts = holder.stmt.executeQuery();
            if (holder.rsts.next()) {
                Object object = this.utils.getObject(holder, 1);
                return (T)object;
            }
            T t = null;
            return t;
        }
    }

    @Override
    public <T> List<T> queryValueList() throws SQLException {
        try (CommandHolder holder = this.utils.buildCommand(this.sql, this.args, false, false);){
            holder.rsts = holder.stmt.executeQuery();
            ArrayList<Object> list = new ArrayList<Object>();
            while (holder.rsts.next()) {
                list.add(this.utils.getObject(holder, 1));
            }
            ArrayList<Object> arrayList = list.size() > 0 ? list : null;
            return arrayList;
        }
    }

    @Override
    public Row queryRow() throws SQLException {
        try (CommandHolder holder = this.utils.buildCommand(this.sql, this.args, false, false);){
            holder.rsts = holder.stmt.executeQuery();
            if (holder.rsts.next()) {
                Row row = holder.getRow();
                return row;
            }
            Row row = null;
            return row;
        }
    }

    @Override
    public RowList queryRowList() throws SQLException {
        try (CommandHolder holder = this.utils.buildCommand(this.sql, this.args, false, false);){
            holder.rsts = holder.stmt.executeQuery();
            SimpleRowList rowList = new SimpleRowList();
            while (holder.rsts.next()) {
                rowList.add(holder.getRow());
            }
            SimpleRowList simpleRowList = rowList.size() > 0 ? rowList : null;
            return simpleRowList;
        }
    }

    @Override
    public RowIterator queryRowIterator(int fetchSize) throws SQLException {
        CommandHolder holder = this.utils.buildCommand(this.sql, this.args, false, true);
        holder.stmt.setFetchSize(fetchSize);
        holder.rsts = holder.stmt.executeQuery();
        return new SimpleRowIterator(holder);
    }

    @Override
    public int update() throws SQLException {
        try (CommandHolder holder = this.utils.buildCommand(this.sql, this.args, false, false);){
            int n = holder.stmt.executeUpdate();
            return n;
        }
    }

    @Override
    public int[] updateBatch(Collection<Object[]> argsList) throws SQLException {
        try (CommandHolder holder = this.utils.buildCommand(this.sql, argsList, false, false);){
            int[] nArray = holder.stmt.executeBatch();
            return nArray;
        }
    }

    @Override
    public <T> T updateReturnKey() throws SQLException {
        try (CommandHolder holder = this.utils.buildCommand(this.sql, this.args, true, false);){
            holder.stmt.executeUpdate();
            holder.rsts = holder.stmt.getGeneratedKeys();
            if (holder.rsts.next()) {
                Object object = holder.rsts.getObject(1);
                return (T)object;
            }
            T t = null;
            return t;
        }
    }
}

