/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.springboot;

import org.noear.solon.core.Aop;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.event.EventBus;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class BeanPostProcessorSolon
implements BeanPostProcessor {
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (!beanName.startsWith("org.springframework") && bean.getClass().getAnnotations().length > 0) {
            try {
                Aop.context().beanInject(bean);
            }
            catch (Throwable ex) {
                EventBus.push((Object)ex);
            }
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (!beanName.startsWith("org.springframework") && bean.getClass().getAnnotations().length > 0) {
            try {
                BeanWrap bw = Aop.wrap(bean.getClass(), (Object)bean);
                if (bean.getClass().getSimpleName().equalsIgnoreCase(beanName)) {
                    Aop.context().beanRegister(bw, null, true);
                } else {
                    Aop.context().beanRegister(bw, beanName, true);
                }
            }
            catch (Throwable ex) {
                EventBus.push((Object)ex);
            }
        }
        return bean;
    }
}

