/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.springboot;

import org.noear.solon.Solon;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.event.EventBus;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class BeanPostProcessorSolon
implements BeanPostProcessor {
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (!beanName.startsWith("org.springframework") && bean.getClass().getAnnotations().length > 0) {
            try {
                Solon.context().beanInject(bean);
            }
            catch (Throwable e) {
                EventBus.pushTry((Object)e);
            }
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (!beanName.startsWith("org.springframework") && bean.getClass().getAnnotations().length > 0) {
            try {
                BeanWrap bw = Solon.context().wrap(bean.getClass(), bean);
                if (bean.getClass().getSimpleName().equalsIgnoreCase(beanName)) {
                    Solon.context().beanRegister(bw, null, true);
                } else {
                    Solon.context().beanRegister(bw, beanName, true);
                }
            }
            catch (Throwable e) {
                EventBus.pushTry((Object)e);
            }
        }
        return bean;
    }
}

