/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.springboot;

import org.noear.solon.Solon;
import org.noear.solon.core.BeanWrap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class BeanPostProcessorSolon
implements BeanPostProcessor {
    static final Logger log = LoggerFactory.getLogger(BeanPostProcessorSolon.class);

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (!beanName.startsWith("org.springframework") && bean.getClass().getAnnotations().length > 0) {
            try {
                Solon.context().beanInject(bean);
            }
            catch (Throwable e) {
                log.warn(e.getMessage(), e);
            }
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (!beanName.startsWith("org.springframework") && bean.getClass().getAnnotations().length > 0) {
            try {
                BeanWrap bw = Solon.context().wrap(bean.getClass(), bean);
                if (bean.getClass().getSimpleName().equalsIgnoreCase(beanName)) {
                    Solon.context().beanRegister(bw, null, true);
                } else {
                    Solon.context().beanRegister(bw, beanName, true);
                }
            }
            catch (Throwable e) {
                log.warn(e.getMessage(), e);
            }
        }
        return bean;
    }
}

