/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.socketd.jdksocket;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.ExecutorService;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.boot.ServerLifecycle;
import org.noear.solon.core.message.Message;
import org.noear.solon.core.message.Session;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.socketd.client.jdksocket.BioReceiver;
import org.noear.solon.socketd.client.jdksocket.BioSocketSession;

class BioServer
implements ServerLifecycle {
    private ServerSocket server;
    private ExecutorService executor;

    BioServer() {
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    private void start0(String host, int port) throws IOException {
        this.server = Utils.isEmpty((String)host) ? new ServerSocket(port) : new ServerSocket(port, 50, Inet4Address.getByName(host));
        LogUtil.global().info("Server started, waiting for customer connection...");
        while (true) {
            Socket socket = this.server.accept();
            Session session = BioSocketSession.get((Socket)socket);
            Solon.app().listener().onOpen(session);
            this.executor.execute(() -> {
                while (true) {
                    if (socket.isClosed()) break;
                    try {
                        Message message = BioReceiver.receive((Socket)socket);
                        if (message == null) continue;
                        Solon.app().listener().onMessage(session, message);
                    }
                    catch (Throwable ex) {
                        Solon.app().listener().onError(session, ex);
                    }
                }
                Solon.app().listener().onClose(session);
                BioSocketSession.remove((Socket)socket);
            });
        }
    }

    public void start(String host, int port) throws Throwable {
        new Thread(() -> {
            try {
                this.start0(host, port);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (SocketException e) {
                if (!e.getMessage().contains("closed")) {
                    throw new RuntimeException(e);
                }
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }).start();
    }

    public void stop() {
        if (this.server == null || this.server.isClosed()) {
            return;
        }
        try {
            this.server.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

