/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.socketd.jdksocket;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.SSLContext;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.boot.ServerLifecycle;
import org.noear.solon.boot.prop.ServerSslProps;
import org.noear.solon.boot.ssl.SslContextFactory;
import org.noear.solon.core.message.Message;
import org.noear.solon.core.message.Session;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.socketd.client.jdksocket.BioReceiver;
import org.noear.solon.socketd.client.jdksocket.BioSocketSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BioServer
implements ServerLifecycle {
    static final Logger log = LoggerFactory.getLogger(BioServer.class);
    private ServerSocket server;
    private ExecutorService executor;
    private ServerSslProps sslProps;

    BioServer() {
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    protected boolean supportSsl() {
        if (this.sslProps == null) {
            this.sslProps = ServerSslProps.of((String)"socket");
        }
        return this.sslProps.isEnable() && this.sslProps.getSslKeyStore() != null;
    }

    private void start0(String host, int port) throws IOException {
        if (this.supportSsl()) {
            SSLContext sslContext = SslContextFactory.create((ServerSslProps)this.sslProps);
            this.server = Utils.isEmpty((String)host) ? sslContext.getServerSocketFactory().createServerSocket(port) : sslContext.getServerSocketFactory().createServerSocket(port, 50, Inet4Address.getByName(host));
        } else {
            this.server = Utils.isEmpty((String)host) ? new ServerSocket(port) : new ServerSocket(port, 50, Inet4Address.getByName(host));
        }
        LogUtil.global().info("Server started, waiting for customer connection...");
        while (true) {
            Socket socket = this.server.accept();
            try {
                Session session = BioSocketSession.get((Socket)socket);
                Solon.app().listener().onOpen(session);
                this.executor.execute(() -> this.execute(session, socket));
                continue;
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
                this.close(socket);
                continue;
            }
            break;
        }
    }

    private void close(Socket socket) {
        try {
            socket.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void execute(Session session, Socket socket) {
        block2: while (true) {
            try {
                while (true) {
                    if (socket.isClosed()) {
                        Solon.app().listener().onClose(session);
                        BioSocketSession.remove((Socket)socket);
                        break block2;
                    }
                    Message message = BioReceiver.receive((Socket)socket);
                    if (message == null) continue;
                    Solon.app().listener().onMessage(session, message);
                }
            }
            catch (Throwable ex) {
                Solon.app().listener().onError(session, ex);
                continue;
            }
            break;
        }
    }

    public void start(String host, int port) throws Throwable {
        new Thread(() -> {
            try {
                this.start0(host, port);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (SocketException e) {
                if (!e.getMessage().contains("closed")) {
                    throw new RuntimeException(e);
                }
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }).start();
    }

    public void stop() {
        if (this.server == null || this.server.isClosed()) {
            return;
        }
        try {
            this.server.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

