/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.socketd.jdksocket;

import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.prop.impl.SocketServerProps;
import org.noear.solon.boot.socketd.jdksocket.BioServer;
import org.noear.solon.boot.socketd.jdksocket._SessionManagerImpl;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Signal;
import org.noear.solon.core.SignalSim;
import org.noear.solon.core.SignalType;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.socketd.SessionManager;

public class XPluginImp
implements Plugin {
    private static Signal _signal;
    BioServer _server;

    public static Signal signal() {
        return _signal;
    }

    public static String solon_boot_ver() {
        return "jdksocket-socketd/" + Solon.version();
    }

    public void start(AppContext context) {
        SessionManager.register((SessionManager)new _SessionManagerImpl());
        if (!Solon.app().enableSocketD()) {
            return;
        }
        context.lifecycle(99, () -> this.start0(Solon.app()));
    }

    private void start0(SolonApp app) throws Throwable {
        ServerProps.init();
        long time_start = System.currentTimeMillis();
        SocketServerProps props = new SocketServerProps(20000);
        String _host = props.getHost();
        int _port = props.getPort();
        String _name = props.getName();
        this._server = new BioServer();
        this._server.setExecutor(props.getBioExecutor("jdksocket-"));
        this._server.start(_host, _port);
        String _wrapHost = props.getWrapHost();
        int _wrapPort = props.getWrapPort();
        _signal = new SignalSim(_name, _wrapHost, _wrapPort, "tcp", SignalType.SOCKET);
        app.signalAdd(_signal);
        long time_end = System.currentTimeMillis();
        LogUtil.global().info("Connector:main: jdksocket-socketd: Started ServerConnector@{[Socket]}{0.0.0.0:" + _port + "}");
        LogUtil.global().info("Server:main: jdksocket-socketd: Started (" + XPluginImp.solon_boot_ver() + ") @" + (time_end - time_start) + "ms");
    }

    public void stop() throws Throwable {
        if (this._server == null) {
            return;
        }
        this._server.stop();
        this._server = null;
        LogUtil.global().info("Server:main: jdksocket-socketd: Has Stopped (" + XPluginImp.solon_boot_ver() + ")");
    }
}

