/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.socketd.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.prop.SocketSignalProps;
import org.noear.solon.boot.socketd.netty.NioServerProcessor;
import org.noear.solon.boot.socketd.netty._SessionManagerImpl;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Signal;
import org.noear.solon.core.SignalSim;
import org.noear.solon.core.SignalType;
import org.noear.solon.core.util.PrintUtil;
import org.noear.solon.socketd.SessionManager;
import org.noear.solon.socketd.client.netty.NioChannelInitializer;

public class XPluginImp
implements Plugin {
    private static Signal _signal;
    ChannelFuture _server;

    public static Signal signal() {
        return _signal;
    }

    public static String solon_boot_ver() {
        return "netty-socketd/" + Solon.cfg().version();
    }

    public void start(AopContext context) {
        SessionManager.register((SessionManager)new _SessionManagerImpl());
        if (!Solon.app().enableSocketD()) {
            return;
        }
        context.beanOnloaded(ctx -> this.start0(Solon.app()));
    }

    private void start0(SolonApp app) {
        ServerProps.init();
        long time_start = System.currentTimeMillis();
        PrintUtil.info((Object)"Server:main: java.net.ServerSocket(netty-socketd)");
        SocketSignalProps props = new SocketSignalProps(20000);
        String _host = props.getHost();
        int _port = props.getPort();
        String _name = props.getName();
        NioEventLoopGroup bossGroup = new NioEventLoopGroup();
        NioEventLoopGroup wokerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap bootstrap = new ServerBootstrap();
            ((ServerBootstrap)bootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)wokerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new NioChannelInitializer(() -> new NioServerProcessor()));
            this._server = Utils.isEmpty((String)_host) ? bootstrap.bind(_port).await() : bootstrap.bind(_host, _port).await();
            _signal = new SignalSim(_name, _port, "tcp", SignalType.SOCKET);
            app.signalAdd(_signal);
            long time_end = System.currentTimeMillis();
            PrintUtil.info((Object)("Connector:main: netty-socketd: Started ServerConnector@{[Socket]}{0.0.0.0:" + _port + "}"));
            PrintUtil.info((Object)("Server:main: netty-socketd: Started @" + (time_end - time_start) + "ms"));
        }
        catch (RuntimeException e) {
            bossGroup.shutdownGracefully();
            wokerGroup.shutdownGracefully();
            throw e;
        }
        catch (Throwable e) {
            bossGroup.shutdownGracefully();
            wokerGroup.shutdownGracefully();
            throw new RuntimeException(e);
        }
    }

    public void stop() throws Throwable {
        if (this._server == null) {
            return;
        }
        this._server.channel().close();
        this._server = null;
        PrintUtil.info((Object)("Server:main: netty-socketd: Has Stopped " + XPluginImp.solon_boot_ver()));
    }
}

