/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.socketd.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.boot.socketd.netty.NioServerProcessor;
import org.noear.solon.boot.socketd.netty._SessionManagerImpl;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Signal;
import org.noear.solon.core.SignalSim;
import org.noear.solon.core.SignalType;
import org.noear.solon.core.util.PrintUtil;
import org.noear.solon.socketd.SessionManager;
import org.noear.solon.socketd.client.netty.NioChannelInitializer;

public class XPluginImp
implements Plugin {
    ChannelFuture _server;

    public static String solon_boot_ver() {
        return "netty-socketd/" + Solon.cfg().version();
    }

    public void start(SolonApp app) {
        SessionManager.register((SessionManager)new _SessionManagerImpl());
        if (!app.enableSocketD()) {
            return;
        }
        new Thread(() -> this.start0(app)).start();
    }

    private void start0(SolonApp app) {
        long time_start = System.currentTimeMillis();
        PrintUtil.info((Object)"solon.server:main: java.net.ServerSocket(netty-socketd)");
        String _name = app.cfg().get("server.socket.name");
        int _port = app.cfg().getInt("server.socket.port", 0);
        if (_port < 1) {
            _port = 20000 + app.port();
        }
        NioEventLoopGroup bossGroup = new NioEventLoopGroup();
        NioEventLoopGroup wokerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap bootstrap = new ServerBootstrap();
            ((ServerBootstrap)bootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)wokerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new NioChannelInitializer(() -> new NioServerProcessor()));
            this._server = bootstrap.bind(_port).sync();
            app.signalAdd((Signal)new SignalSim(_name, _port, "tcp", SignalType.SOCKET));
            long time_end = System.currentTimeMillis();
            PrintUtil.info((Object)("solon.connector:main: netty-socketd: Started ServerConnector@{[Socket]}{0.0.0.0:" + _port + "}"));
            PrintUtil.info((Object)("solon.server:main: netty-socketd: Started @" + (time_end - time_start) + "ms"));
        }
        catch (Exception ex) {
            bossGroup.shutdownGracefully();
            wokerGroup.shutdownGracefully();
            ex.printStackTrace();
        }
    }

    public void stop() throws Throwable {
        if (this._server == null) {
            return;
        }
        this._server.channel().close();
        this._server = null;
        PrintUtil.info((Object)("solon.server:main: netty-socketd: Has Stopped " + XPluginImp.solon_boot_ver()));
    }
}

