/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.socketd.rsocket;

import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.prop.impl.SocketServerProps;
import org.noear.solon.boot.socketd.rsocket.RsServer;
import org.noear.solon.boot.socketd.rsocket._SessionManagerImpl;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Signal;
import org.noear.solon.core.SignalSim;
import org.noear.solon.core.SignalType;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.socketd.SessionManager;

public class XPluginImp
implements Plugin {
    private static Signal _signal;
    RsServer _server;

    public static Signal signal() {
        return _signal;
    }

    public static String solon_boot_ver() {
        return "rsocket-socketd/" + Solon.cfg().version();
    }

    public void start(AopContext context) {
        SessionManager.register((SessionManager)new _SessionManagerImpl());
        if (!Solon.app().enableSocketD()) {
            return;
        }
        context.beanOnloaded(ctx -> this.start0(Solon.app()));
    }

    private void start0(SolonApp app) {
        ServerProps.init();
        long time_start = System.currentTimeMillis();
        LogUtil.global().info("Server:main: java.net.ServerSocket(rsocket-socketd)");
        SocketServerProps props = new SocketServerProps(20000);
        String _host = props.getHost();
        int _port = props.getPort();
        String _name = props.getName();
        try {
            this._server = new RsServer();
            this._server.start(_host, _port);
            String _wrapHost = props.getWrapHost();
            int _wrapPort = props.getWrapPort();
            _signal = new SignalSim(_name, _wrapHost, _wrapPort, "tcp", SignalType.SOCKET);
            app.signalAdd(_signal);
            long time_end = System.currentTimeMillis();
            LogUtil.global().info("Connector:main: rsocket-socketd: Started ServerConnector@{[Socket]}{0.0.0.0:" + _port + "}");
            LogUtil.global().info("Server:main: rsocket-socketd: Started @" + (time_end - time_start) + "ms");
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    public void stop() throws Throwable {
        if (this._server == null) {
            return;
        }
        this._server.stop();
        this._server = null;
        LogUtil.global().info("Server:main: rsocket-socketd: Has Stopped " + XPluginImp.solon_boot_ver());
    }
}

