/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.rsocket;

import io.rsocket.RSocket;
import io.rsocket.util.DefaultPayload;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.message.Message;
import org.noear.solon.core.message.Session;
import org.noear.solon.extend.socketd.Connector;
import org.noear.solon.extend.socketd.ListenerProxy;
import org.noear.solon.extend.socketd.ProtocolManager;
import org.noear.solon.extend.socketd.SessionBase;

class _SocketSession
extends SessionBase {
    public static Map<RSocket, Session> sessions = new HashMap<RSocket, Session>();
    RSocket real;
    Connector<RSocket> connector;
    boolean autoReconnect;
    private String _sessionId = Utils.guid();
    private Object attachment;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session get(RSocket real) {
        Object tmp = sessions.get(real);
        if (tmp == null) {
            RSocket rSocket = real;
            synchronized (rSocket) {
                tmp = sessions.get(real);
                if (tmp == null) {
                    tmp = new _SocketSession(real);
                    sessions.put(real, (Session)tmp);
                    ListenerProxy.getGlobal().onOpen(tmp);
                }
            }
        }
        return tmp;
    }

    public static void remove(RSocket real) {
        sessions.remove(real);
    }

    public _SocketSession(RSocket real) {
        this.real = real;
    }

    public _SocketSession(Connector<RSocket> connector) {
        this.connector = connector;
    }

    private boolean prepareNew() throws IOException {
        if (this.real == null) {
            this.real = (RSocket)this.connector.open((Session)this);
            this.onOpen();
            return true;
        }
        return false;
    }

    public Object real() {
        return this.real;
    }

    public String sessionId() {
        return this._sessionId;
    }

    public MethodType method() {
        return MethodType.SOCKET;
    }

    public URI uri() {
        if (this.connector == null) {
            return null;
        }
        return this.connector.uri();
    }

    public String path() {
        if (this.connector == null) {
            return "";
        }
        return this.connector.uri().getPath();
    }

    public void send(String message) {
        this.send(Message.wrap((String)message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message message) {
        try {
            super.send(message);
            _SocketSession _SocketSession2 = this;
            synchronized (_SocketSession2) {
                if (this.prepareNew()) {
                    this.send0(this.handshakeMessage);
                }
                this.send0(message);
            }
        }
        catch (RuntimeException ex) {
            Throwable ex2 = Utils.throwableUnwrap((Throwable)ex);
            if (ex2 instanceof ConnectException && this.autoReconnect) {
                this.real = null;
            }
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void send0(Message message) {
        if (message == null) {
            return;
        }
        ByteBuffer byteBuffer = ProtocolManager.encode((Message)message);
        if (byteBuffer != null) {
            this.real.fireAndForget(DefaultPayload.create((ByteBuffer)byteBuffer)).doOnError(err -> ListenerProxy.getGlobal().onError((Session)this, err)).subscribe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        RSocket rSocket = this.real;
        synchronized (rSocket) {
            this.real.dispose();
            sessions.remove(this.real);
        }
    }

    public boolean isValid() {
        return !this.real.isDisposed();
    }

    public boolean isSecure() {
        return false;
    }

    public InetSocketAddress getRemoteAddress() {
        return null;
    }

    public InetSocketAddress getLocalAddress() {
        return null;
    }

    public void setAttachment(Object obj) {
        this.attachment = obj;
    }

    public <T> T getAttachment() {
        return (T)this.attachment;
    }

    public Collection<Session> getOpenSessions() {
        return new ArrayList<Session>(sessions.values());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        _SocketSession that = (_SocketSession)((Object)o);
        return Objects.equals(this.real, that.real);
    }

    public int hashCode() {
        return Objects.hash(this.real);
    }
}

