/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.sessionstate.jwt;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.impl.DefaultClaims;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.SessionStateDefault;
import org.noear.solon.extend.sessionstate.jwt.JwtUtils;
import org.noear.solon.extend.sessionstate.jwt.SessionProp;

public class JwtSessionState
extends SessionStateDefault {
    private static int _expiry = 7200;
    private static String _domain = null;
    private Context ctx;
    private Claims sessionMap;
    private String sessionToken;

    protected JwtSessionState(Context ctx) {
        this.ctx = ctx;
    }

    public String cookieGet(String key) {
        return this.ctx.cookie(key);
    }

    public void cookieSet(String key, String val) {
        if (SessionProp.session_state_domain_auto && _domain != null && this.ctx.uri().getHost().indexOf(_domain) < 0) {
            this.ctx.cookieSet(key, val, null, _expiry);
            return;
        }
        this.ctx.cookieSet(key, val, _domain, _expiry);
    }

    public String sessionId() {
        if (SessionProp.session_jwt_allowUseHeader) {
            return "";
        }
        String _sessionId = (String)this.ctx.attr("sessionId", null);
        if (_sessionId == null) {
            _sessionId = this.sessionId_get(false);
            this.ctx.attrSet("sessionId", (Object)_sessionId);
        }
        return _sessionId;
    }

    public String sessionChangeId() {
        this.sessionId_get(true);
        this.ctx.attrSet("sessionId", null);
        return this.sessionId();
    }

    private String sessionId_get(boolean reset) {
        String skey = this.cookieGet("SOLONID");
        String smd5 = this.cookieGet(JwtSessionState.SESSIONID_MD5());
        if (!reset && !Utils.isEmpty((String)skey) && !Utils.isEmpty((String)smd5) && Utils.md5((String)(skey + "&L8e!@T0")).equals(smd5)) {
            return skey;
        }
        skey = Utils.guid();
        this.cookieSet("SOLONID", skey);
        this.cookieSet(JwtSessionState.SESSIONID_MD5(), Utils.md5((String)(skey + "&L8e!@T0")));
        return skey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Claims sessionMap() {
        if (this.sessionMap == null) {
            JwtSessionState jwtSessionState = this;
            synchronized (jwtSessionState) {
                if (this.sessionMap == null) {
                    Claims claims;
                    this.sessionMap = new DefaultClaims();
                    String sesId = this.sessionId();
                    String token = this.jwtGet();
                    if (Utils.isNotEmpty((String)token) && token.contains(".") && (claims = JwtUtils.parseJwt(token)) != null && (SessionProp.session_jwt_allowUseHeader || sesId.equals(claims.getId()))) {
                        if (SessionProp.session_jwt_allowExpire) {
                            if (claims.getExpiration() != null && claims.getExpiration().getTime() > System.currentTimeMillis()) {
                                this.sessionMap = claims;
                            }
                        } else {
                            this.sessionMap = claims;
                        }
                    }
                    this.sessionToken = null;
                }
            }
        }
        return this.sessionMap;
    }

    public Object sessionGet(String key) {
        return this.sessionMap().get((Object)key);
    }

    public void sessionSet(String key, Object val) {
        this.sessionMap().put((Object)key, val);
        this.sessionToken = null;
    }

    public void sessionClear() {
        this.sessionMap().clear();
        this.sessionToken = null;
    }

    public void sessionReset() {
        this.sessionClear();
        this.sessionChangeId();
    }

    public void sessionRefresh() {
        if (SessionProp.session_jwt_allowUseHeader) {
            return;
        }
        String skey = this.cookieGet("SOLONID");
        if (Utils.isNotEmpty((String)skey)) {
            this.cookieSet("SOLONID", skey);
            this.cookieSet(JwtSessionState.SESSIONID_MD5(), Utils.md5((String)(skey + "&L8e!@T0")));
        }
    }

    public void sessionPublish() {
        String token;
        if (SessionProp.session_jwt_allowAutoIssue && Utils.isNotEmpty((String)(token = this.sessionToken()))) {
            this.jwtSet(token);
        }
    }

    public String sessionToken() {
        Claims tmp;
        if (this.sessionToken == null && (tmp = this.sessionMap()) != null) {
            if (SessionProp.session_jwt_allowUseHeader && tmp.size() == 0) {
                this.sessionToken = "";
            }
            if (this.sessionToken == null) {
                String skey = this.sessionId();
                if (SessionProp.session_jwt_allowUseHeader || Utils.isNotEmpty((String)skey)) {
                    tmp.setId(skey);
                    this.sessionToken = SessionProp.session_jwt_allowExpire ? JwtUtils.buildJwt(tmp, (long)_expiry * 1000L) : JwtUtils.buildJwt(tmp, 0L);
                }
            }
        }
        return this.sessionToken;
    }

    public boolean replaceable() {
        return false;
    }

    protected String jwtGet() {
        if (SessionProp.session_jwt_allowUseHeader) {
            return this.ctx.header(SessionProp.session_jwt_name);
        }
        return this.cookieGet(SessionProp.session_jwt_name);
    }

    protected void jwtSet(String token) {
        if (SessionProp.session_jwt_allowUseHeader) {
            this.ctx.headerSet(SessionProp.session_jwt_name, token);
        } else {
            this.cookieSet(SessionProp.session_jwt_name, token);
        }
        this.ctx.attrSet(SessionProp.session_jwt_name, (Object)token);
    }

    static {
        if (SessionProp.session_timeout > 0) {
            _expiry = SessionProp.session_timeout;
        }
        if (SessionProp.session_state_domain != null) {
            _domain = SessionProp.session_state_domain;
        }
    }
}

