/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.sessionstate.jwt;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.io.Decoders;
import io.jsonwebtoken.io.Encoders;
import io.jsonwebtoken.security.Keys;
import java.security.Key;
import java.util.Date;
import javax.crypto.SecretKey;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.extend.sessionstate.jwt.JwtSessionStateFactory;
import org.noear.solon.extend.sessionstate.jwt.SessionProp;

public class JwtUtils {
    private static String TOKEN_HEADER = "Bearer ";
    private static Key key = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Key key() {
        if (key == null) {
            JwtSessionStateFactory jwtSessionStateFactory = JwtSessionStateFactory.getInstance();
            synchronized (jwtSessionStateFactory) {
                if (key == null) {
                    String signKey0 = JwtSessionStateFactory.getInstance().signKey();
                    key = Keys.hmacShaKeyFor((byte[])((byte[])Decoders.BASE64.decode((Object)signKey0)));
                }
            }
        }
        return key;
    }

    public static String createKey() {
        SecretKey key = Keys.secretKeyFor((SignatureAlgorithm)SignatureAlgorithm.HS256);
        return (String)Encoders.BASE64.encode((Object)key.getEncoded());
    }

    public static String buildJwt(Claims claims, long expire) {
        return JwtUtils.buildJwt(claims, expire, JwtUtils.key());
    }

    public static String buildJwt(Claims claims, long expire, Key secret) {
        JwtBuilder builder = expire > 0L ? Jwts.builder().setClaims(claims).setIssuedAt(new Date()).setExpiration(new Date(System.currentTimeMillis() + expire)) : Jwts.builder().setClaims(claims).setIssuedAt(new Date());
        if (Utils.isNotEmpty((String)Solon.cfg().appName())) {
            builder.setIssuer(Solon.cfg().appName());
        }
        if (Utils.isNotEmpty((String)SessionProp.session_jwt_prefix)) {
            return SessionProp.session_jwt_prefix + " " + builder.signWith(secret).compact();
        }
        return builder.signWith(secret).compact();
    }

    public static Claims parseJwt(String token) {
        return JwtUtils.parseJwt(token, JwtUtils.key());
    }

    public static Claims parseJwt(String token, Key signKey) {
        if (token.startsWith(TOKEN_HEADER)) {
            token = token.substring(TOKEN_HEADER.length()).trim();
        }
        if (Utils.isNotEmpty((String)SessionProp.session_jwt_prefix) && token.startsWith(SessionProp.session_jwt_prefix)) {
            token = token.substring(SessionProp.session_jwt_prefix.length()).trim();
        }
        try {
            return (Claims)Jwts.parserBuilder().setSigningKey(signKey).build().parseClaimsJws(token).getBody();
        }
        catch (ExpiredJwtException expiredJwtException) {
        }
        catch (Exception ex) {
            EventBus.push((Object)ex);
        }
        return null;
    }
}

