/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami.channel.socketd;

import java.util.Map;
import java.util.function.Supplier;
import org.noear.nami.NamiChannel;
import org.noear.nami.NamiConfig;
import org.noear.nami.Result;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.message.Message;
import org.noear.solon.core.message.Session;

public class SocketChannel
implements NamiChannel {
    public Supplier<Session> sessions;

    public SocketChannel(Supplier<Session> sessions) {
        this.sessions = sessions;
    }

    public Result call(NamiConfig cfg, String method, String url, Map<String, String> headers, Map<String, Object> args) throws Throwable {
        Message response;
        cfg.getDecoder().filter(cfg, method, url, headers, args);
        Message message = null;
        String message_key = Utils.guid();
        switch (cfg.getEncoder().enctype()) {
            case application_hessian: {
                headers.put("Content-Type", "application/hessian");
                message = Message.wrap((String)message_key, (String)url, (String)this.headerToString(headers), (byte[])((byte[])cfg.getEncoder().encode(args)));
                break;
            }
            default: {
                headers.put("Content-Type", "application/json");
                String json = (String)cfg.getEncoder().encode(args);
                message = Message.wrap((String)message_key, (String)url, (String)this.headerToString(headers), (byte[])json.getBytes());
                break;
            }
        }
        if (Solon.cfg().isFilesMode()) {
            System.out.println(message.toString());
        }
        if ((response = this.sessions.get().sendAndResponse(message)) == null) {
            return null;
        }
        Result result = new Result(200, response.body());
        return result;
    }

    private String headerToString(Map<String, String> headers) {
        StringBuilder header = new StringBuilder();
        if (headers != null) {
            headers.forEach((k, v) -> header.append((String)k).append("=").append((String)v).append("&"));
        }
        return header.toString();
    }
}

