/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.socketd;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.solon.Solon;
import org.noear.solon.core.message.Listener;
import org.noear.solon.core.message.Message;
import org.noear.solon.core.message.Session;
import org.noear.solon.extend.socketd.SocketContextHandler;

public class ListenerProxy
implements Listener {
    private static Listener global = new ListenerProxy();
    private SocketContextHandler socketContextHandler = new SocketContextHandler();
    public static long REQUEST_AND_RESPONSE_TIMEOUT_SECONDS = 10L;
    private static Map<String, CompletableFuture<Message>> requests = new ConcurrentHashMap<String, CompletableFuture<Message>>();

    public static Listener getGlobal() {
        return global;
    }

    public static void setGlobal(Listener global) {
        ListenerProxy.global = global;
    }

    protected static void regRequest(Message message, CompletableFuture<Message> future) {
        requests.putIfAbsent(message.key(), future);
    }

    public void onOpen(Session session) {
        Listener sl = this.get(session);
        if (sl != null) {
            sl.onOpen(session);
        }
    }

    public void onMessage(Session session, Message message, boolean messageIsString) {
        CompletableFuture<Message> request;
        if (message.flag() == 1 && (request = requests.get(message.key())) != null) {
            requests.remove(message.key());
            request.complete(message);
            return;
        }
        Listener sl = this.get(session);
        if (sl != null) {
            sl.onMessage(session, message, messageIsString);
        }
        if (!message.getHandled()) {
            this.socketContextHandler.handle(session, message, messageIsString);
        }
    }

    public void onClose(Session session) {
        Listener sl = this.get(session);
        if (sl != null) {
            sl.onClose(session);
        }
    }

    public void onError(Session session, Throwable error) {
        Listener sl = this.get(session);
        if (sl != null) {
            sl.onError(session, error);
        }
    }

    private Listener get(Session s) {
        return Solon.global().router().matchOne(s);
    }
}

