/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.socketd;

import java.nio.ByteBuffer;
import org.noear.solon.core.message.Message;

public class MessageUtils {
    public static ByteBuffer encode(Message msg) {
        byte[] keyB = msg.key().getBytes(msg.getCharset());
        byte[] resourceDescriptorB = msg.resourceDescriptor().getBytes(msg.getCharset());
        byte[] headerB = msg.header().getBytes(msg.getCharset());
        int len = keyB.length + resourceDescriptorB.length + headerB.length + msg.body().length + 6 + 4 + 4;
        ByteBuffer buffer = ByteBuffer.allocate(len);
        buffer.putInt(len);
        buffer.putInt(msg.flag());
        buffer.put(keyB);
        buffer.putChar('\n');
        buffer.put(resourceDescriptorB);
        buffer.putChar('\n');
        buffer.put(headerB);
        buffer.putChar('\n');
        buffer.put(msg.body());
        buffer.flip();
        return buffer;
    }

    public static Message decode(ByteBuffer buffer) {
        int len0 = buffer.getInt();
        if (len0 > buffer.remaining() + 4) {
            return null;
        }
        int flag = buffer.getInt();
        ByteBuffer sb = ByteBuffer.allocate(Math.min(1024, buffer.limit()));
        String key = MessageUtils.decodeString(buffer, sb, 256);
        if (key == null) {
            return null;
        }
        String resourceDescriptor = MessageUtils.decodeString(buffer, sb, 256);
        if (resourceDescriptor == null) {
            return null;
        }
        String header = MessageUtils.decodeString(buffer, sb, 0);
        if (header == null) {
            return null;
        }
        int len = len0 - buffer.position();
        byte[] body = new byte[len];
        if (len > 0) {
            buffer.get(body, 0, len);
        }
        return Message.wrap((int)flag, (String)key, (String)resourceDescriptor, (String)header, (byte[])body);
    }

    private static String decodeString(ByteBuffer buffer, ByteBuffer sb, int maxLen) {
        byte c;
        sb.clear();
        while ((c = buffer.get()) != 10) {
            if (c != 0) {
                sb.put(c);
            }
            if (maxLen <= 0 || maxLen >= sb.position()) continue;
            return null;
        }
        sb.flip();
        if (sb.limit() < 1) {
            return "";
        }
        return new String(sb.array(), 0, sb.limit());
    }
}

