/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.socketd;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.noear.solon.Utils;
import org.noear.solon.core.message.Message;
import org.noear.solon.core.message.Session;
import org.noear.solon.extend.socketd.ListenerProxy;

public abstract class SessionBase
implements Session {
    public Message sendAndResponse(Message message) {
        if (Utils.isEmpty((String)message.key())) {
            throw new IllegalArgumentException("SendAndResponse message no key");
        }
        CompletableFuture<Message> request = new CompletableFuture<Message>();
        ListenerProxy.regRequest(message, request);
        this.send(message);
        try {
            return request.get(ListenerProxy.REQUEST_AND_RESPONSE_TIMEOUT_SECONDS, TimeUnit.SECONDS);
        }
        catch (Throwable ex) {
            throw Utils.throwableWrap((Throwable)ex);
        }
    }

    public void sendAndCallback(Message message, BiConsumer<Message, Throwable> callback) {
        if (Utils.isEmpty((String)message.key())) {
            throw new IllegalArgumentException("sendAndCallback message no key");
        }
        CompletableFuture<Message> request = new CompletableFuture<Message>();
        ListenerProxy.regRequest(message, request);
        request.whenCompleteAsync((BiConsumer)callback);
        this.send(message);
    }
}

