/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.validation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Note;
import org.noear.solon.core.handle.Action;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.Result;
import org.noear.solon.extend.validation.Validator;
import org.noear.solon.extend.validation.ValidatorFailureHandler;
import org.noear.solon.extend.validation.annotation.Date;
import org.noear.solon.extend.validation.annotation.DateValidator;
import org.noear.solon.extend.validation.annotation.DecimalMax;
import org.noear.solon.extend.validation.annotation.DecimalMaxValidator;
import org.noear.solon.extend.validation.annotation.DecimalMin;
import org.noear.solon.extend.validation.annotation.DecimalMinValidator;
import org.noear.solon.extend.validation.annotation.Email;
import org.noear.solon.extend.validation.annotation.EmailValidator;
import org.noear.solon.extend.validation.annotation.Length;
import org.noear.solon.extend.validation.annotation.LengthValidator;
import org.noear.solon.extend.validation.annotation.Max;
import org.noear.solon.extend.validation.annotation.MaxValidator;
import org.noear.solon.extend.validation.annotation.Min;
import org.noear.solon.extend.validation.annotation.MinValidator;
import org.noear.solon.extend.validation.annotation.NoRepeatLock;
import org.noear.solon.extend.validation.annotation.NoRepeatLockImp;
import org.noear.solon.extend.validation.annotation.NoRepeatSubmit;
import org.noear.solon.extend.validation.annotation.NoRepeatSubmitValidator;
import org.noear.solon.extend.validation.annotation.NotBlank;
import org.noear.solon.extend.validation.annotation.NotBlankValidator;
import org.noear.solon.extend.validation.annotation.NotEmpty;
import org.noear.solon.extend.validation.annotation.NotEmptyValidator;
import org.noear.solon.extend.validation.annotation.NotNull;
import org.noear.solon.extend.validation.annotation.NotNullValidator;
import org.noear.solon.extend.validation.annotation.NotZero;
import org.noear.solon.extend.validation.annotation.NotZeroValidator;
import org.noear.solon.extend.validation.annotation.Null;
import org.noear.solon.extend.validation.annotation.NullValidator;
import org.noear.solon.extend.validation.annotation.Numeric;
import org.noear.solon.extend.validation.annotation.NumericValidator;
import org.noear.solon.extend.validation.annotation.Pattern;
import org.noear.solon.extend.validation.annotation.PatternValidator;
import org.noear.solon.extend.validation.annotation.Whitelist;
import org.noear.solon.extend.validation.annotation.WhitelistChecker;
import org.noear.solon.extend.validation.annotation.WhitelistCheckerImp;
import org.noear.solon.extend.validation.annotation.WhitelistValidator;

public class ValidatorManager
implements Handler {
    private static ValidatorManager global = new ValidatorManager();
    protected final Map<Class<? extends Annotation>, Validator> validMap = new HashMap<Class<? extends Annotation>, Validator>();
    protected ValidatorFailureHandler failureHandler;

    public static ValidatorManager global() {
        return global;
    }

    public static void globalSet(ValidatorManager global) {
        if (global != null) {
            ValidatorManager.global = global;
        }
    }

    public static void setNoRepeatLock(NoRepeatLock lock) {
        NoRepeatLockImp.globalSet(lock);
    }

    public static void setWhitelistChecker(WhitelistChecker checker) {
        WhitelistCheckerImp.globalSet(checker);
    }

    public ValidatorManager() {
        this.failureHandler = new ValidatorFailureHandlerImp();
        this.initialize();
    }

    public ValidatorManager(ValidatorFailureHandler handler) {
        this.failureHandler = handler == null ? new ValidatorFailureHandlerImp() : handler;
        this.initialize();
    }

    public void onFailure(ValidatorFailureHandler handler) {
        if (handler != null) {
            this.failureHandler = handler;
        }
    }

    protected void initialize() {
        this.register(Date.class, DateValidator.instance);
        this.register(DecimalMax.class, DecimalMaxValidator.instance);
        this.register(DecimalMin.class, DecimalMinValidator.instance);
        this.register(Email.class, EmailValidator.instance);
        this.register(Max.class, MaxValidator.instance);
        this.register(Min.class, MinValidator.instance);
        this.register(NoRepeatSubmit.class, NoRepeatSubmitValidator.instance);
        this.register(NotBlank.class, NotBlankValidator.instance);
        this.register(NotEmpty.class, NotEmptyValidator.instance);
        this.register(NotNull.class, NotNullValidator.instance);
        this.register(NotZero.class, NotZeroValidator.instance);
        this.register(Null.class, NullValidator.instance);
        this.register(Numeric.class, NumericValidator.instance);
        this.register(Pattern.class, PatternValidator.instance);
        this.register(Length.class, LengthValidator.instance);
        this.register(Whitelist.class, WhitelistValidator.instance);
    }

    @Note(value="\u6e05\u9664\u6240\u6709\u9a8c\u8bc1\u5668")
    public void clear() {
        this.validMap.clear();
    }

    @Note(value="\u79fb\u9664\u67d0\u4e2a\u7c7b\u578b\u7684\u9a8c\u8bc1\u5668")
    public <T extends Annotation> void remove(Class<T> type) {
        this.validMap.remove(type);
    }

    @Note(value="\u6ce8\u518c\u9a8c\u8bc1\u5668")
    public <T extends Annotation> void register(Class<T> type, Validator<T> validator) {
        this.validMap.put(type, validator);
    }

    public void handle(Context ctx) throws Throwable {
        Action action = ctx.action();
        if (action != null) {
            this.validate(ctx, action);
        }
    }

    protected void validate(Context ctx, Action action) throws Throwable {
        StringBuilder tmp = new StringBuilder();
        for (Annotation anno : action.bean().annotations()) {
            if (!this.validateDo(ctx, anno, null, tmp)) continue;
            return;
        }
        for (Annotation anno : action.method().getAnnotations()) {
            if (!this.validateDo(ctx, anno, null, tmp)) continue;
            return;
        }
        for (Parameter para : action.method().getParameters()) {
            for (Annotation anno : para.getAnnotations()) {
                if (!this.validateDo(ctx, anno, para.getName(), tmp)) continue;
                return;
            }
        }
    }

    protected boolean validateDo(Context ctx, Annotation anno, String name, StringBuilder tmp) {
        if (ctx.getHandled()) {
            return true;
        }
        Validator valid = this.validMap.get(anno.annotationType());
        if (valid != null) {
            tmp.setLength(0);
            Result rst = valid.validate(ctx, anno, name, tmp);
            if (rst.getCode() != 1 && this.failureDo(ctx, anno, rst, valid.message(anno))) {
                return true;
            }
        }
        return false;
    }

    protected boolean failureDo(Context ctx, Annotation ano, Result result, String message) {
        return this.failureHandler.onFailure(ctx, ano, result, message);
    }

    static class ValidatorFailureHandlerImp
    implements ValidatorFailureHandler {
        ValidatorFailureHandlerImp() {
        }

        @Override
        public boolean onFailure(Context ctx, Annotation ano, Result rst, String message) {
            ctx.setHandled(true);
            ctx.statusSet(400);
            try {
                if (Utils.isEmpty((String)message)) {
                    message = Utils.isEmpty((String)rst.getDescription()) ? new StringBuilder(100).append("@").append(ano.annotationType().getSimpleName()).append(" verification failed").toString() : new StringBuilder(100).append("@").append(ano.annotationType().getSimpleName()).append(" verification failed: ").append(rst.getDescription()).toString();
                }
                ctx.render((Object)Result.failure((int)400, (String)message));
            }
            catch (Throwable ex) {
                throw Utils.throwableWrap((Throwable)ex);
            }
            return true;
        }
    }
}

