/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.util.Map;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.Aop;
import org.noear.solon.logging.AppenderManager;
import org.noear.solon.logging.LogOptions;
import org.noear.solon.logging.event.Level;
import org.noear.solon.logging.event.LogEvent;
import org.slf4j.Logger;
import org.slf4j.MDC;
import org.slf4j.Marker;
import org.slf4j.helpers.MessageFormatter;

public class SolonLogger
implements Logger {
    private String name;
    private Level level = Level.TRACE;

    public SolonLogger(String name) {
        this.name = name;
        if (Solon.global() != null) {
            this.level = LogOptions.getLoggerLevel((String)name);
        } else {
            Aop.beanOnloaded(() -> {
                this.level = LogOptions.getLoggerLevel((String)name);
            });
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isTraceEnabled() {
        return this.level.code <= Level.TRACE.code;
    }

    public void trace(String s) {
        this.appendDo(Level.TRACE, s, null, null);
    }

    public void trace(String s, Object o) {
        this.appendDo(Level.TRACE, null, s, new Object[]{o});
    }

    public void trace(String s, Object o, Object o1) {
        this.appendDo(Level.TRACE, null, s, new Object[]{o, o1});
    }

    public void trace(String s, Object ... objects) {
        this.appendDo(Level.TRACE, null, s, objects);
    }

    public void trace(String s, Throwable throwable) {
        this.appendDo(Level.TRACE, null, s, new Object[]{throwable});
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.isTraceEnabled();
    }

    public void trace(Marker marker, String s) {
        this.trace(s);
    }

    public void trace(Marker marker, String s, Object o) {
        this.trace(s, o);
    }

    public void trace(Marker marker, String s, Object o, Object o1) {
        this.trace(s, o, o1);
    }

    public void trace(Marker marker, String s, Object ... objects) {
        this.trace(s, objects);
    }

    public void trace(Marker marker, String s, Throwable throwable) {
        this.trace(s, throwable);
    }

    public boolean isDebugEnabled() {
        return this.level.code <= Level.DEBUG.code;
    }

    public void debug(String s) {
        this.appendDo(Level.DEBUG, s, null, null);
    }

    public void debug(String s, Object o) {
        this.appendDo(Level.DEBUG, null, s, new Object[]{o});
    }

    public void debug(String s, Object o, Object o1) {
        this.appendDo(Level.DEBUG, null, s, new Object[]{o, o1});
    }

    public void debug(String s, Object ... objects) {
        this.appendDo(Level.DEBUG, null, s, objects);
    }

    public void debug(String s, Throwable throwable) {
        this.appendDo(Level.DEBUG, null, s, new Object[]{throwable});
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.isDebugEnabled();
    }

    public void debug(Marker marker, String s) {
        this.debug(s, (Object)s);
    }

    public void debug(Marker marker, String s, Object o) {
        this.debug(s, o);
    }

    public void debug(Marker marker, String s, Object o, Object o1) {
        this.debug(s, o, o1);
    }

    public void debug(Marker marker, String s, Object ... objects) {
        this.debug(s, objects);
    }

    public void debug(Marker marker, String s, Throwable throwable) {
        this.debug(s, throwable);
    }

    public boolean isInfoEnabled() {
        return this.level.code <= Level.INFO.code;
    }

    public void info(String s) {
        this.appendDo(Level.INFO, s, null, null);
    }

    public void info(String s, Object o) {
        this.appendDo(Level.INFO, null, s, new Object[]{o});
    }

    public void info(String s, Object o, Object o1) {
        this.appendDo(Level.INFO, null, s, new Object[]{o, o1});
    }

    public void info(String s, Object ... objects) {
        this.appendDo(Level.INFO, null, s, objects);
    }

    public void info(String s, Throwable throwable) {
        this.appendDo(Level.INFO, null, s, new Object[]{throwable});
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.isInfoEnabled();
    }

    public void info(Marker marker, String s) {
        this.info(s);
    }

    public void info(Marker marker, String s, Object o) {
        this.info(s, o);
    }

    public void info(Marker marker, String s, Object o, Object o1) {
        this.info(s, o, o1);
    }

    public void info(Marker marker, String s, Object ... objects) {
        this.info(s, objects);
    }

    public void info(Marker marker, String s, Throwable throwable) {
        this.info(s, throwable);
    }

    public boolean isWarnEnabled() {
        return this.level.code <= Level.WARN.code;
    }

    public void warn(String s) {
        this.appendDo(Level.WARN, s, null, null);
    }

    public void warn(String s, Object o) {
        this.appendDo(Level.WARN, null, s, new Object[]{o});
    }

    public void warn(String s, Object ... objects) {
        this.appendDo(Level.WARN, null, s, objects);
    }

    public void warn(String s, Object o, Object o1) {
        this.appendDo(Level.WARN, null, s, new Object[]{o, o1});
    }

    public void warn(String s, Throwable throwable) {
        this.appendDo(Level.WARN, null, s, new Object[]{throwable});
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.isWarnEnabled();
    }

    public void warn(Marker marker, String s) {
        this.warn(s);
    }

    public void warn(Marker marker, String s, Object o) {
        this.warn(s, o);
    }

    public void warn(Marker marker, String s, Object o, Object o1) {
        this.warn(s, o, o1);
    }

    public void warn(Marker marker, String s, Object ... objects) {
        this.warn(s, objects);
    }

    public void warn(Marker marker, String s, Throwable throwable) {
        this.warn(s, throwable);
    }

    public boolean isErrorEnabled() {
        return this.level.code <= Level.ERROR.code;
    }

    public void error(String s) {
        this.appendDo(Level.ERROR, s, null, null);
    }

    public void error(String s, Object o) {
        this.appendDo(Level.ERROR, null, s, new Object[]{o});
    }

    public void error(String s, Object o, Object o1) {
        this.appendDo(Level.ERROR, null, s, new Object[]{o, o1});
    }

    public void error(String s, Object ... objects) {
        this.appendDo(Level.ERROR, null, s, objects);
    }

    public void error(String s, Throwable throwable) {
        this.appendDo(Level.ERROR, null, s, new Object[]{throwable});
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.isErrorEnabled();
    }

    public void error(Marker marker, String s) {
        this.error(s);
    }

    public void error(Marker marker, String s, Object o) {
        this.error(s, o);
    }

    public void error(Marker marker, String s, Object o, Object o1) {
        this.error(s, o, o1);
    }

    public void error(Marker marker, String s, Object ... objects) {
        this.error(s, objects);
    }

    public void error(Marker marker, String s, Throwable throwable) {
        this.error(s, throwable);
    }

    private void appendDo(Level level, String content, String format, Object[] args) {
        if (level.code < this.level.code) {
            return;
        }
        Map metainfo = MDC.getCopyOfContextMap();
        Throwable throwable = null;
        String throwableStr = null;
        if (format != null) {
            if (args != null && args.length > 0) {
                int len = args.length;
                for (int i = 0; i < len; ++i) {
                    if (!(args[i] instanceof Throwable)) continue;
                    throwable = Utils.throwableUnwrap((Throwable)((Throwable)args[i]));
                    throwableStr = Utils.throwableToString((Throwable)throwable);
                    args[i] = throwableStr;
                    break;
                }
                content = MessageFormatter.arrayFormat((String)format, (Object[])args, null).getMessage();
            } else {
                content = format;
            }
            if (throwableStr != null) {
                if (Utils.isEmpty((String)content)) {
                    content = throwableStr;
                } else if (throwableStr.length() > content.length()) {
                    content = content + "\n" + throwableStr;
                }
            }
        }
        LogEvent logEvent = new LogEvent(this.getName(), level, metainfo, (Object)content, System.currentTimeMillis(), Thread.currentThread().getName(), throwable);
        AppenderManager.getInstance().append(logEvent);
    }
}

