/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.socketd.client.netty;

import io.netty.channel.Channel;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.message.Message;
import org.noear.solon.core.message.Session;
import org.noear.solon.socketd.Connector;
import org.noear.solon.socketd.SessionBase;

public class NioSocketSession
extends SessionBase {
    public static Map<Channel, Session> sessions = new HashMap<Channel, Session>();
    Channel real;
    Connector<Channel> connector;
    boolean autoReconnect;
    private String _sessionId = Utils.guid();
    private Object attachment;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session get(Channel real) {
        Object tmp = sessions.get(real);
        if (tmp == null) {
            Channel channel = real;
            synchronized (channel) {
                tmp = sessions.get(real);
                if (tmp == null) {
                    tmp = new NioSocketSession(real);
                    sessions.put(real, (Session)tmp);
                }
            }
        }
        return tmp;
    }

    public static void remove(Channel real) {
        sessions.remove(real);
    }

    public NioSocketSession(Channel real) {
        this.real = real;
    }

    public NioSocketSession(Connector<Channel> connector) {
        this.connector = connector;
        this.autoReconnect = connector.autoReconnect();
    }

    private boolean prepareNew() throws IOException {
        if (this.real == null) {
            this.real = (Channel)this.connector.open((Session)this);
            this.onOpen();
            return true;
        }
        if (this.autoReconnect && !this.real.isActive()) {
            this.real = (Channel)this.connector.open((Session)this);
            this.onOpen();
            return true;
        }
        return false;
    }

    public Object real() {
        return this.real;
    }

    public String sessionId() {
        return this._sessionId;
    }

    public MethodType method() {
        return MethodType.SOCKET;
    }

    public URI uri() {
        if (this.connector == null) {
            return null;
        }
        return this.connector.uri();
    }

    public String path() {
        if (this.connector == null) {
            return "";
        }
        return this.connector.uri().getPath();
    }

    public void send(String message) {
        this.send(Message.wrap((String)message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message message) {
        try {
            super.send(message);
            NioSocketSession nioSocketSession = this;
            synchronized (nioSocketSession) {
                if (this.prepareNew()) {
                    this.send0(this.handshakeMessage);
                }
                this.send0(message);
            }
        }
        catch (RuntimeException ex) {
            Throwable ex2 = Utils.throwableUnwrap((Throwable)ex);
            if (ex2 instanceof ConnectException && this.autoReconnect) {
                this.real = null;
            }
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void send0(Message message) throws IOException {
        if (message == null) {
            return;
        }
        this.real.writeAndFlush((Object)message);
    }

    public void close() throws IOException {
        this.real.close();
        sessions.remove(this.real);
    }

    public boolean isValid() {
        return this.real.isActive();
    }

    public boolean isSecure() {
        return false;
    }

    public InetSocketAddress getRemoteAddress() {
        try {
            return (InetSocketAddress)this.real.remoteAddress();
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public InetSocketAddress getLocalAddress() {
        try {
            return (InetSocketAddress)this.real.localAddress();
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setAttachment(Object obj) {
        this.attachment = obj;
    }

    public <T> T getAttachment() {
        return (T)this.attachment;
    }

    public Collection<Session> getOpenSessions() {
        return new ArrayList<Session>(sessions.values());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        NioSocketSession that = (NioSocketSession)((Object)o);
        return Objects.equals(this.real, that.real);
    }

    public int hashCode() {
        return Objects.hash(this.real);
    }
}

