/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.socketd.client.netty;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.ssl.SslHandler;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.noear.solon.core.message.Message;
import org.noear.solon.socketd.client.netty.MessageDecoder;
import org.noear.solon.socketd.client.netty.MessageEncoder;

public class NioChannelInitializer
extends ChannelInitializer<SocketChannel> {
    Supplier<SimpleChannelInboundHandler<Message>> processor;
    SSLContext sslContext;
    boolean clientMode;

    public NioChannelInitializer(SSLContext sslContext, boolean clientMode, Supplier<SimpleChannelInboundHandler<Message>> processor) {
        this.processor = processor;
        this.sslContext = sslContext;
        this.clientMode = clientMode;
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        if (this.sslContext != null) {
            SSLEngine engine = this.sslContext.createSSLEngine();
            if (!this.clientMode) {
                engine.setUseClientMode(false);
                engine.setNeedClientAuth(true);
            }
            pipeline.addFirst(new ChannelHandler[]{new SslHandler(engine)});
        }
        pipeline.addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, -4, 0)});
        pipeline.addLast(new ChannelHandler[]{new MessageDecoder()});
        pipeline.addLast(new ChannelHandler[]{new MessageEncoder()});
        pipeline.addLast(new ChannelHandler[]{(ChannelHandler)this.processor.get()});
    }
}

