/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.noear.solon.XApp;
import org.noear.solon.XUtil;
import org.noear.solon.annotation.XAfter;
import org.noear.solon.annotation.XBefore;
import org.noear.solon.annotation.XMapping;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.XAction;
import org.noear.solon.core.XHandler;
import org.noear.solon.core.XRender;
import org.noear.solon.ext.Act1Ex;

public class BeanWebWrap {
    protected BeanWrap _bw;
    protected XMapping _cxm;
    protected XRender _render = null;
    protected int _poi = 1;
    protected boolean _rpc = false;

    public BeanWebWrap(BeanWrap wrap) {
        this._bw = wrap;
        if (this._bw.raw() instanceof XRender) {
            this._render = (XRender)this._bw.raw();
        }
        this._cxm = this._bw.clz().getAnnotation(XMapping.class);
    }

    public void renderSet(XRender render) {
        this._render = render;
    }

    public void endpointSet(int endpoint) {
        this._poi = endpoint;
    }

    public void rpcSet(boolean rpc) {
        this._rpc = rpc;
    }

    public void load(XApp app) {
        if (XHandler.class.isAssignableFrom(this._bw.clz())) {
            this.do_loadHandler(app, this._bw, this._cxm);
        } else {
            this.do_loadAction(app);
        }
    }

    protected void do_loadHandler(XApp app, BeanWrap bw, XMapping cxm) {
        if (cxm == null) {
            throw new RuntimeException(bw.clz().getName() + " No XMapping!");
        }
        switch (this._poi) {
            case 0: {
                app.before(cxm.value(), cxm.method(), (XHandler)bw.raw());
                break;
            }
            case 2: {
                app.after(cxm.value(), cxm.method(), (XHandler)bw.raw());
                break;
            }
            default: {
                app.add(cxm.value(), cxm.method(), (XHandler)bw.raw());
            }
        }
    }

    private void do_loadAction(XApp app) {
        XMapping m_map = null;
        String c_path = "";
        if (this._cxm != null) {
            c_path = this._cxm.value();
        }
        XBefore c_befs = this._bw.clz().getAnnotation(XBefore.class);
        XAfter c_afts = this._bw.clz().getAnnotation(XAfter.class);
        ArrayList c_befs2 = new ArrayList();
        ArrayList c_afts2 = new ArrayList();
        if (c_befs != null) {
            BeanWebWrap.do_add(c_befs.value(), b -> c_befs2.add(b.newInstance()));
        }
        if (c_afts != null) {
            BeanWebWrap.do_add(c_afts.value(), f -> c_afts2.add(f.newInstance()));
        }
        block4: for (Method method : this._bw.clz().getDeclaredMethods()) {
            String m_method;
            String m_path;
            m_map = method.getAnnotation(XMapping.class);
            XBefore m_befores = method.getAnnotation(XBefore.class);
            XAfter m_afters = method.getAnnotation(XAfter.class);
            if (m_map != null) {
                m_path = m_map.value();
                m_method = m_map.method();
            } else {
                m_path = method.getName();
                m_method = this._cxm == null ? "" : this._cxm.method();
            }
            if (m_map == null && !this._rpc) continue;
            String newPath = XUtil.mergePath(c_path, m_path);
            XAction action = new XAction(this._bw, this._render, this._rpc, method, newPath);
            BeanWebWrap.do_add(c_befs2.toArray(), b -> action.before((XHandler)b));
            if (m_befores != null) {
                BeanWebWrap.do_add(m_befores.value(), b -> action.before((XHandler)b.newInstance()));
            }
            BeanWebWrap.do_add(c_afts2.toArray(), f -> action.after((XHandler)f));
            if (m_afters != null) {
                BeanWebWrap.do_add(m_afters.value(), f -> action.after((XHandler)f.newInstance()));
            }
            switch (this._poi) {
                case 0: {
                    app.before(newPath, m_method, action);
                    continue block4;
                }
                case 2: {
                    app.after(newPath, m_method, action);
                    continue block4;
                }
                default: {
                    app.add(newPath, m_method, action);
                }
            }
        }
    }

    private static <T> void do_add(T[] ary, Act1Ex<T> fun) {
        if (ary != null) {
            for (T t : ary) {
                try {
                    fun.run(t);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }
}

