/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon;

import org.noear.solon.SolonApp;
import org.noear.solon.SolonProps;
import org.noear.solon.Utils;
import org.noear.solon.core.JarClassLoader;
import org.noear.solon.core.NvMap;
import org.noear.solon.core.util.PrintUtil;
import org.noear.solon.ext.ConsumerEx;

public class Solon {
    private static SolonApp global;
    private static boolean _stopped;

    public static SolonApp global() {
        return global;
    }

    public static SolonProps cfg() {
        return Solon.global().cfg();
    }

    public static SolonApp start(Class<?> source, String[] args) {
        return Solon.start(source, args, null);
    }

    public static SolonApp start(Class<?> source, String[] args, ConsumerEx<SolonApp> initialize) {
        NvMap argx = NvMap.from(args);
        return Solon.start(source, argx, initialize);
    }

    public static SolonApp start(Class<?> source, NvMap argx, ConsumerEx<SolonApp> initialize) {
        if (global != null) {
            return global;
        }
        JarClassLoader.bindingThread();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> Solon.stop(false, 0L)));
        long time_start = System.currentTimeMillis();
        PrintUtil.blueln("solon.App:: Start loading");
        global = new SolonApp(source, argx);
        global.init();
        if (initialize != null) {
            try {
                initialize.accept(global);
            }
            catch (Throwable ex) {
                throw Utils.throwableWrap(ex);
            }
        }
        global.run();
        long time_end = System.currentTimeMillis();
        PrintUtil.blueln("solon.App:: End loading @" + (time_end - time_start) + "ms");
        return global;
    }

    public static void stop() {
        Solon.stop(true, 0L);
    }

    public static void stop(boolean exit, long delay) {
        if (global == null) {
            return;
        }
        _stopped = true;
        Utils.pools.submit(() -> {
            if (delay > 0L) {
                Thread.sleep(delay);
            }
            global.cfg().plugs().forEach(p -> p.stop());
            global = null;
            if (exit) {
                System.exit(0);
            }
            return null;
        });
    }

    public static boolean stopped() {
        return _stopped;
    }
}

