/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.handle;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.annotation.Note;
import org.noear.solon.core.Aop;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.Action;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Filter;
import org.noear.solon.core.handle.FilterChain;
import org.noear.solon.core.handle.FilterChainNode;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.HandlerAide;
import org.noear.solon.core.handle.HandlerLoader;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.util.PathUtil;
import org.noear.solon.ext.DataThrowable;
import org.noear.solon.ext.RunnableEx;

public abstract class Gateway
extends HandlerAide
implements Handler,
Render {
    private Handler mainDef;
    private final Map<String, Handler> main = new HashMap<String, Handler>();
    private final String mapping;
    private Mapping mappingAnno = this.getClass().getAnnotation(Mapping.class);
    private FilterChainNode filterChain;

    public Gateway() {
        if (this.mappingAnno == null) {
            throw new RuntimeException("No Mapping!");
        }
        this.mapping = this.mappingAnno.value();
        this.mainDef = c -> c.statusSet(404);
        this.filterChain = new FilterChainNode(this::doFilter);
        this.register();
    }

    @Note(value="\u6ce8\u518c\u76f8\u5173\u63a5\u53e3\u4e0e\u62e6\u622a\u5668")
    protected abstract void register();

    @Note(value="\u5141\u8bb8 Action Mapping \u7533\u660e")
    protected boolean allowActionMapping() {
        return true;
    }

    @Note(value="\u5145\u8bb8\u63d0\u524d\u51c6\u5907\u63a7\u5236\u5668")
    protected boolean allowReadyController() {
        return true;
    }

    @Note(value="\u5145\u8bb8\u8def\u5f84\u5408\u5e76")
    protected boolean allowPathMerging() {
        return true;
    }

    @Override
    public void render(Object obj, Context c) throws Throwable {
        if (c.getRendered()) {
            return;
        }
        c.setRendered(true);
        c.result = obj;
        c.render(obj);
    }

    public void filter(Filter filter) {
        FilterChainNode tmp = new FilterChainNode(filter);
        tmp.next = this.filterChain;
        this.filterChain = tmp;
    }

    @Override
    public void handle(Context c) throws Throwable {
        try {
            this.filterChain.doFilter(c);
        }
        catch (Throwable ex) {
            c.errors = ex;
            this.render(ex, c);
            EventBus.push(ex);
        }
    }

    protected void doFilter(Context c, FilterChain chain) throws Throwable {
        Handler m = this.find(c);
        Object obj = null;
        if (m != null) {
            Boolean is_action = m instanceof Action;
            if (is_action.booleanValue()) {
                if (this.allowReadyController()) {
                    obj = ((Action)m).bean().get();
                    c.attrSet("controller", obj);
                }
                c.attrSet("action", m);
            }
            this.handle0(c, m, obj, is_action);
        }
    }

    private void handle0(Context c, Handler m, Object obj, Boolean is_action) throws Throwable {
        this.handleDo(c, () -> {
            for (Handler h : this.befores) {
                h.handle(c);
            }
        });
        if (!c.getHandled()) {
            this.handleDo(c, () -> {
                if (is_action.booleanValue()) {
                    ((Action)m).invoke(c, obj);
                } else {
                    m.handle(c);
                }
            });
        } else {
            this.render(c.result, c);
        }
        for (Handler h : this.afters) {
            h.handle(c);
        }
    }

    protected void handleDo(Context c, RunnableEx runnable) throws Throwable {
        try {
            runnable.run();
        }
        catch (DataThrowable ex) {
            c.setHandled(true);
            this.render(ex, c);
        }
        catch (Throwable ex) {
            c.setHandled(true);
            c.errors = ex;
            this.render(ex, c);
            EventBus.push(ex);
        }
    }

    @Note(value="\u6dfb\u52a0\u524d\u7f6e\u62e6\u622a\u5668")
    public <T extends Handler> void before(Class<T> interceptorClz) {
        super.before((Handler)Aop.get(interceptorClz));
    }

    @Note(value="\u6dfb\u52a0\u540e\u7f6e\u62e6\u622a\u5668")
    public <T extends Handler> void after(Class<T> interceptorClz) {
        super.after((Handler)Aop.get(interceptorClz));
    }

    @Note(value="\u6dfb\u52a0\u63a5\u53e3")
    public void addBeans(Predicate<BeanWrap> where) {
        Aop.beanOnloaded(() -> Aop.beanForeach(bw -> {
            if (where.test((BeanWrap)bw)) {
                this.add((BeanWrap)bw);
            }
        }));
    }

    @Note(value="\u6dfb\u52a0\u63a5\u53e3")
    public void add(Class<?> beanClz) {
        if (beanClz != null) {
            BeanWrap bw = Aop.wrapAndPut(beanClz);
            this.add(bw, bw.remoting());
        }
    }

    @Note(value="\u6dfb\u52a0\u63a5\u53e3")
    public void add(String path, Class<?> beanClz) {
        if (beanClz != null) {
            BeanWrap bw = Aop.wrapAndPut(beanClz);
            this.add(path, bw, bw.remoting());
        }
    }

    @Note(value="\u6dfb\u52a0\u63a5\u53e3")
    public void add(Class<?> beanClz, boolean remoting) {
        if (beanClz != null) {
            this.add(Aop.wrapAndPut(beanClz), remoting);
        }
    }

    @Note(value="\u6dfb\u52a0\u63a5\u53e3")
    public void add(String path, Class<?> beanClz, boolean remoting) {
        if (beanClz != null) {
            this.add(path, Aop.wrapAndPut(beanClz), remoting);
        }
    }

    @Note(value="\u6dfb\u52a0\u63a5\u53e3")
    public void add(BeanWrap beanWp) {
        this.add(beanWp, beanWp.remoting());
    }

    @Note(value="\u6dfb\u52a0\u63a5\u53e3")
    public void add(String path, BeanWrap beanWp) {
        this.add(path, beanWp, beanWp.remoting());
    }

    @Note(value="\u6dfb\u52a0\u63a5\u53e3")
    public void add(BeanWrap beanWp, boolean remoting) {
        this.add(null, beanWp, remoting);
    }

    @Note(value="\u6dfb\u52a0\u63a5\u53e3")
    public void add(String path, BeanWrap beanWp, boolean remoting) {
        if (beanWp == null) {
            return;
        }
        HandlerLoader uw = new HandlerLoader(beanWp, this.mapping, remoting, this, this.allowActionMapping());
        uw.load((p1, m, h) -> {
            if (h instanceof Action) {
                Action h2 = (Action)h;
                if (Utils.isEmpty(h2.name())) {
                    this.mainDef = h2;
                } else if (path == null) {
                    this.add(h2.name(), h2);
                } else {
                    this.add(PathUtil.mergePath(path, h2.name()), h2);
                }
            }
        });
    }

    @Note(value="\u6dfb\u52a0\u4e8c\u7ea7\u8def\u5f84\u5904\u7406")
    public void add(String path, Handler handler) {
        this.addDo(path, handler);
    }

    protected void addDo(String path, Handler handler) {
        if (this.allowPathMerging()) {
            this.main.put(PathUtil.mergePath(this.mapping, path).toUpperCase(), handler);
        } else {
            this.main.put(path.toUpperCase(), handler);
        }
    }

    protected Handler getDo(String path) {
        if (path == null) {
            return null;
        }
        return this.main.get(path);
    }

    protected Handler find(Context c) throws Throwable {
        return this.findDo(c, c.pathNew().toUpperCase());
    }

    protected Handler findDo(Context c, String path) throws Throwable {
        Handler h = this.getDo(path);
        if (h == null) {
            this.mainDef.handle(c);
            c.setHandled(true);
            return this.mainDef;
        }
        if (h instanceof Action) {
            c.attrSet("handler_name", ((Action)h).name());
        }
        return h;
    }
}

