/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.wrap;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.util.ConvertUtil;
import org.noear.solon.core.wrap.FieldWrap;

public class ClassWrap {
    private static Map<Class<?>, ClassWrap> cached = new ConcurrentHashMap();
    private final Class<?> _clz;
    private final Method[] methods;
    private final List<FieldWrap> fieldWraps;
    private final Map<String, FieldWrap> fieldAllWrapsMap;
    private boolean _recordable;
    private Constructor _recordConstructor;
    private Parameter[] _recordParams;

    public static ClassWrap get(Class<?> clz) {
        ClassWrap l;
        ClassWrap cw = cached.get(clz);
        if (cw == null && (l = cached.putIfAbsent(clz, cw = new ClassWrap(clz))) != null) {
            cw = l;
        }
        return cw;
    }

    protected ClassWrap(Class<?> clz) {
        this._clz = clz;
        this._recordable = true;
        this.methods = clz.getDeclaredMethods();
        this.fieldWraps = new ArrayList<FieldWrap>();
        this.fieldAllWrapsMap = new LinkedHashMap<String, FieldWrap>();
        this.doScanAllFields(clz, this.fieldAllWrapsMap::containsKey, this.fieldAllWrapsMap::put);
        for (Field f : clz.getDeclaredFields()) {
            FieldWrap fw = this.fieldAllWrapsMap.get(f.getName());
            if (fw == null) continue;
            this.fieldWraps.add(fw);
        }
        if (this.fieldWraps.size() == 0) {
            this._recordable = false;
        }
        if (this._recordable) {
            this._recordConstructor = clz.getConstructors()[0];
            this._recordParams = this._recordConstructor.getParameters();
        }
    }

    public Class<?> clz() {
        return this._clz;
    }

    public Map<String, FieldWrap> getFieldAllWraps() {
        return Collections.unmodifiableMap(this.fieldAllWrapsMap);
    }

    public FieldWrap getFieldWrap(String field) {
        return this.fieldAllWrapsMap.get(field);
    }

    public Method[] getMethods() {
        return this.methods;
    }

    public boolean recordable() {
        return this._recordable;
    }

    public Constructor recordConstructor() {
        return this._recordConstructor;
    }

    public Parameter[] recordParams() {
        return this._recordParams;
    }

    public <T> T newBy(Properties data) {
        try {
            Constructor<?> constructor = this.clz().getConstructor(Properties.class);
            if (constructor != null) {
                return (T)constructor.newInstance(data);
            }
        }
        catch (Throwable throwable) {
        }
        return this.newBy(data::getProperty);
    }

    public <T> T newBy(Function<String, String> data) {
        return this.newBy(data, null);
    }

    public <T> T newBy(Function<String, String> data, Context ctx) {
        try {
            if (this.recordable()) {
                Parameter[] argsP = this.recordParams();
                Object[] argsV = new Object[argsP.length];
                for (int i = 0; i < argsP.length; ++i) {
                    Object val;
                    Parameter p = argsP[i];
                    String key = p.getName();
                    String val0 = data.apply(key);
                    argsV[i] = val0 != null ? (val = ConvertUtil.to(p, p.getType(), key, val0, ctx)) : null;
                }
                Object obj = this.recordConstructor().newInstance(argsV);
                return obj;
            }
            Object obj = this.clz().newInstance();
            this.fill(obj, data, ctx);
            return (T)obj;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void fill(Object bean, Function<String, String> data) {
        this.fill(bean, data, null);
    }

    private void fill(Object bean, Function<String, String> data, Context ctx) {
        for (Map.Entry<String, FieldWrap> kv : this.fieldAllWrapsMap.entrySet()) {
            String key = kv.getKey();
            String val0 = data.apply(key);
            if (val0 == null) continue;
            FieldWrap fw = kv.getValue();
            Object val = ConvertUtil.to(fw.field, fw.type, key, val0, ctx);
            fw.setValue(bean, val);
        }
    }

    private void doScanAllFields(Class<?> clz, Predicate<String> checker, BiConsumer<String, FieldWrap> consumer) {
        if (clz == null) {
            return;
        }
        for (Field f : clz.getDeclaredFields()) {
            int mod = f.getModifiers();
            if (Modifier.isStatic(mod) || Modifier.isTransient(mod) || checker.test(f.getName())) continue;
            this._recordable &= Modifier.isFinal(mod);
            consumer.accept(f.getName(), new FieldWrap(this._clz, f, Modifier.isFinal(mod)));
        }
        Class<?> sup = clz.getSuperclass();
        if (sup != Object.class) {
            this.doScanAllFields(sup, checker, consumer);
        }
    }
}

