/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solonjt.executor.s.lua;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.noear.snack.ONode;
import org.noear.solon.XApp;
import org.noear.solon.core.XContext;
import org.noear.solonjt.executor.IJtExecutor;
import org.noear.solonjt.executor.s.lua.LuaUtil;
import org.noear.solonjt.executor.s.lua.__JTEAPI_CLZ;
import org.noear.solonjt.model.AFileModel;
import org.noear.solonjt.utils.Datetime;
import org.noear.solonjt.utils.ThreadData;
import org.noear.solonjt.utils.Timecount;
import org.noear.solonjt.utils.Timespan;

public class LuaJtExecutor
implements IJtExecutor {
    private static final ThreadData<StringBuilder> _tlBuilder = new ThreadData(() -> new StringBuilder(5120));
    private static final String _lock = "";
    private static LuaJtExecutor _g;
    private final ScriptEngine _eng;
    private final Set<String> _loaded_names = Collections.synchronizedSet(new HashSet());
    private final Bindings _bindings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LuaJtExecutor singleton() {
        if (_g != null) return _g;
        String string = _lock;
        synchronized (_lock) {
            if (_g != null) return _g;
            _g = new LuaJtExecutor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _g;
        }
    }

    private LuaJtExecutor() {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        this._eng = scriptEngineManager.getEngineByName("luaj");
        this._bindings = this._eng.getBindings(100);
        XApp.global().shared().forEach((k, v) -> this.sharedSet((String)k, v));
        XApp.global().onSharedAdd((k, v) -> this.sharedSet((String)k, v));
        this.sharedSet("__JTEAPI", new __JTEAPI_CLZ());
        this.sharedSet("XContext", XContext.class);
        this.sharedSet("ONode", ONode.class);
        this.sharedSet("Datetime", Datetime.class);
        this.sharedSet("Timecount", Timecount.class);
        this.sharedSet("Timespan", Timespan.class);
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("require 'org.luaj.vm2.lib.DebugLib'\n\n");
            sb.append("\n");
            sb.append("__global = {lib={},lib_new={}}\n\n");
            sb.append("function modelAndView(tml,mod)\n    return __JTEAPI:modelAndView(tml,mod)\nend\n\n");
            sb.append("function requireX(path)\n    if string.sub(path,1,1) == '$' then\n        path = string.sub(path,2)\n        __JTEAPI:require(path)\n        return __global['lib_new'][path]()\n    else\n        __JTEAPI:require(path)\n        return __global['lib'][path]\n    end\nend\n\n");
            sb.append("function funX(f)\n    return luajava.createProxy('org.noear.solonjt.dso.JtFunHandler', {call=f})\nend\n\n");
            this._eng.eval(sb.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void sharedSet(String name, Object val) {
        this._eng.put(name, val);
    }

    public String language() {
        return "lua";
    }

    public boolean isLoaded(String name2) {
        return this._loaded_names.contains(name2);
    }

    public boolean preLoad(String name2, AFileModel file) throws Exception {
        if (!this.isLoaded(name2)) {
            this._loaded_names.add(name2);
            this._eng.eval(this.compilerAsFun(name2, file));
        }
        return true;
    }

    public void del(String name) {
        String name2 = name.replace(".", "_").replace("*", "_");
        this._loaded_names.remove(name2);
        this._loaded_names.remove(name2 + "__lib");
    }

    public void delAll() {
        this._loaded_names.clear();
    }

    public Object exec(String name, AFileModel file, XContext ctx, Map<String, Object> model, boolean outString) throws Exception {
        String name2 = name.replace(".", "_").replace("*", "_");
        this.preLoad(name2, file);
        Object tmp = this._eng.eval("return API_" + name2 + "(XContext:current())");
        if (tmp == null) {
            return null;
        }
        if (outString) {
            if (tmp instanceof Number || tmp instanceof String || tmp instanceof Boolean) {
                return tmp.toString();
            }
            Object obj = LuaUtil.luaToObj(tmp);
            return ONode.loadObj((Object)obj).toJson();
        }
        return LuaUtil.luaToObj(tmp);
    }

    public Object exec(String code, Map<String, Object> model) throws Exception {
        if (model != null) {
            Bindings bindings = this._eng.createBindings();
            bindings.putAll(this._bindings);
            bindings.putAll((Map<? extends String, ? extends Object>)model);
            return this._eng.eval(code, bindings);
        }
        return this._eng.eval(code);
    }

    public String compilerAsFun(String name, AFileModel file) {
        StringBuilder sb = (StringBuilder)_tlBuilder.get();
        sb.setLength(0);
        String[] lines = file.content.split("\n");
        sb.append("function API_").append(name).append("(ctx)\n");
        int len2 = lines.length;
        for (int i = 0; i < len2; ++i) {
            sb.append("    ").append(lines[i]).append("\n");
        }
        sb.append("end\n");
        if (name.endsWith("__lib")) {
            sb.append("__global['lib']['").append(file.path).append("']=").append("API_").append(name).append("();");
            sb.append("\n");
            sb.append("__global['lib_new']['").append(file.path).append("']=").append("API_").append(name).append(";");
        }
        return sb.toString();
    }
}

