/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.sureness.integration;

import com.usthe.sureness.matcher.DefaultPathRoleMatcher;
import com.usthe.sureness.matcher.PathTreeProvider;
import com.usthe.sureness.matcher.TreePathRoleMatcher;
import com.usthe.sureness.mgt.SurenessSecurityManager;
import com.usthe.sureness.processor.DefaultProcessorManager;
import com.usthe.sureness.processor.ProcessorManager;
import com.usthe.sureness.processor.support.DigestProcessor;
import com.usthe.sureness.processor.support.JwtProcessor;
import com.usthe.sureness.processor.support.NoneProcessor;
import com.usthe.sureness.processor.support.PasswordProcessor;
import com.usthe.sureness.provider.SurenessAccountProvider;
import com.usthe.sureness.provider.ducument.DocumentAccountProvider;
import com.usthe.sureness.provider.ducument.DocumentPathTreeProvider;
import com.usthe.sureness.subject.SubjectCreate;
import com.usthe.sureness.subject.SubjectFactory;
import com.usthe.sureness.subject.SurenessSubjectFactory;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.noear.solon.annotation.Configuration;
import org.noear.solon.extend.sureness.support.BasicSubjectSolonCreator;
import org.noear.solon.extend.sureness.support.DigestSubjectSolonCreator;
import org.noear.solon.extend.sureness.support.JwtSubjectSolonCreator;
import org.noear.solon.extend.sureness.support.NoneSubjectSolonCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Configuration
public class SurenessConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(SurenessConfiguration.class);

    public SurenessConfiguration() {
        this.init();
    }

    private void init() {
        DocumentAccountProvider accountProvider = new DocumentAccountProvider();
        LinkedList<Object> processorList = new LinkedList<Object>();
        NoneProcessor noneProcessor = new NoneProcessor();
        processorList.add(noneProcessor);
        JwtProcessor jwtProcessor = new JwtProcessor();
        processorList.add(jwtProcessor);
        PasswordProcessor passwordProcessor = new PasswordProcessor();
        passwordProcessor.setAccountProvider((SurenessAccountProvider)accountProvider);
        processorList.add(passwordProcessor);
        DigestProcessor digestProcessor = new DigestProcessor();
        digestProcessor.setAccountProvider((SurenessAccountProvider)accountProvider);
        processorList.add(digestProcessor);
        DefaultProcessorManager processorManager = new DefaultProcessorManager(processorList);
        if (logger.isDebugEnabled()) {
            logger.debug("DefaultProcessorManager init");
        }
        DocumentPathTreeProvider pathTreeProvider = new DocumentPathTreeProvider();
        DefaultPathRoleMatcher pathRoleMatcher = new DefaultPathRoleMatcher();
        pathRoleMatcher.setPathTreeProvider((PathTreeProvider)pathTreeProvider);
        pathRoleMatcher.buildTree();
        if (logger.isDebugEnabled()) {
            logger.debug("DefaultPathRoleMatcher init");
        }
        SurenessSubjectFactory subjectFactory = new SurenessSubjectFactory();
        List<SubjectCreate> subjectCreates = Arrays.asList(new NoneSubjectSolonCreator(), new DigestSubjectSolonCreator(), new BasicSubjectSolonCreator(), new JwtSubjectSolonCreator());
        subjectFactory.registerSubjectCreator(subjectCreates);
        if (logger.isDebugEnabled()) {
            logger.debug("SurenessSubjectFactory init");
        }
        SurenessSecurityManager securityManager = SurenessSecurityManager.getInstance();
        securityManager.setPathRoleMatcher((TreePathRoleMatcher)pathRoleMatcher);
        securityManager.setSubjectFactory((SubjectFactory)subjectFactory);
        securityManager.setProcessorManager((ProcessorManager)processorManager);
        if (logger.isDebugEnabled()) {
            logger.debug("SurenessSecurityManager init");
        }
    }
}

