/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.protocol.solution;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.noear.water.log.Level;
import org.noear.water.log.LogEvent;
import org.noear.water.protocol.LogSource;
import org.noear.water.protocol.model.LogModel;
import org.noear.water.utils.Datetime;
import org.noear.water.utils.TextUtils;
import org.noear.weed.DbContext;
import org.noear.weed.DbTableQuery;

public class LogSourceDb
implements LogSource {
    DbContext _db;

    public LogSourceDb(DbContext db) {
        this._db = db;
    }

    @Override
    public List<LogModel> query(String logger, String trace_id, Integer level, int size, String tag, String tag1, String tag2, String tag3, Integer log_date, Long log_id) throws Exception {
        if (TextUtils.isEmpty((CharSequence)logger)) {
            return new ArrayList<LogModel>();
        }
        if (log_date == null) {
            log_date = 0;
        }
        if (log_id == null) {
            log_id = 0L;
        }
        if (level == null) {
            level = 0;
        }
        return ((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)this._db.table(logger).where("1 = 1", new Object[0])).andIf(TextUtils.isNotEmpty((CharSequence)trace_id), "trace_id = ?", new Object[]{trace_id})).andIf(TextUtils.isNotEmpty((CharSequence)tag), "tag = ?", new Object[]{tag})).andIf(TextUtils.isNotEmpty((CharSequence)tag1), "tag1 = ?", new Object[]{tag1})).andIf(TextUtils.isNotEmpty((CharSequence)tag2), "tag2 = ?", new Object[]{tag2})).andIf(TextUtils.isNotEmpty((CharSequence)tag3), "tag3 = ?", new Object[]{tag3})).andIf(log_date > 0, "log_date = ?", new Object[]{log_date})).andIf(log_id > 0L, "log_id <= ?", new Object[]{log_id})).andIf(level > 0, "level=?", new Object[]{level})).orderBy("log_fulltime desc")).limit(size)).select("*").getList(LogModel.class);
    }

    @Override
    public void write(long log_id, String logger, String trace_id, Level level, String tag, String tag1, String tag2, String tag3, String summary, Object content, String from, Date log_fulltime) {
        try {
            DbTableQuery qr = ((DbTableQuery)this._db.table(logger).usingExpr(true)).set("log_id", (Object)log_id).set("trace_id", (Object)trace_id).set("level", (Object)level.code).setDf("tag", (Object)tag, (Object)"").setDf("tag1", (Object)tag1, (Object)"").setDf("tag2", (Object)tag2, (Object)"").setDf("tag3", (Object)tag3, (Object)"").setDf("summary", (Object)summary, (Object)"").setDf("content", content, (Object)"").setDf("from", (Object)from, (Object)"");
            if (log_fulltime == null) {
                qr.set("log_date", (Object)"$DATE(NOW())").set("log_fulltime", (Object)"$NOW()").insert();
            } else {
                qr.set("log_date", (Object)new Datetime(log_fulltime).getDate()).set("log_fulltime", (Object)log_fulltime).insert();
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void writeAll(String logger, List<LogEvent> list) {
        if (list.size() == 0) {
            return;
        }
        try {
            this._db.table(logger).insertList(list, (log, item) -> item.set("log_id", (Object)log.log_id).set("trace_id", (Object)log.trace_id).set("level", (Object)log.level).setDf("tag", (Object)log.tag, (Object)"").setDf("tag1", (Object)log.tag1, (Object)"").setDf("tag2", (Object)log.tag2, (Object)"").setDf("tag3", (Object)log.tag3, (Object)"").setDf("summary", (Object)log.summary, (Object)"").setDf("content", log.content, (Object)"").setDf("from", (Object)log.from, (Object)"").setDf("log_date", (Object)log.log_date, (Object)"$DATE(NOW())").setDf("log_fulltime", (Object)log.log_fulltime, (Object)"$NOW()"));
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void clear(String logger, int keep_days) {
        int date = Datetime.Now().addDay(-keep_days).getDate();
        try {
            ((DbTableQuery)this._db.table(logger).where("log_date <= ?", new Object[]{date})).delete();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

