/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.protocol.solution;

import java.util.Properties;
import org.noear.water.model.ConfigM;
import org.noear.water.model.PropertiesM;
import org.noear.water.protocol.LogSource;
import org.noear.water.protocol.MessageQueue;
import org.noear.water.protocol.solution.LogSourceDb;
import org.noear.water.protocol.solution.MessageQueueRabbitMQ;
import org.noear.water.protocol.solution.MessageQueueRedis;
import org.noear.water.protocol.solution.MessageQueueRocketMQ;
import org.noear.water.utils.RabbitMQX;
import org.noear.water.utils.RedisX;
import org.noear.water.utils.TextUtils;

public class ProtocolUtil {
    public static MessageQueue createMessageQueue(ConfigM cfg) {
        PropertiesM prop = cfg.getProp();
        String name = prop.getProperty("queue.name", "").toLowerCase();
        String type = prop.getProperty("queue.type", "").toLowerCase();
        if (TextUtils.isEmpty((CharSequence)type) || TextUtils.isEmpty((CharSequence)type)) {
            throw new RuntimeException("ProtocolHub::There was an error in the input configuration");
        }
        if ("redis".equals(type)) {
            return new MessageQueueRedis(name, new RedisX((Properties)prop));
        }
        if ("rabbitmq".equals(type)) {
            return new MessageQueueRabbitMQ(name, new RabbitMQX((Properties)prop));
        }
        if ("rocketmq".equals(type)) {
            return new MessageQueueRocketMQ(name, (Properties)prop);
        }
        throw new RuntimeException("ProtocolHub::There was an error in the input configuration");
    }

    public static LogSource createLogSource(ConfigM cfg) {
        if (cfg == null || TextUtils.isEmpty((CharSequence)cfg.value)) {
            return null;
        }
        return new LogSourceDb(cfg.getDb(true));
    }
}

