CREATE TABLE IF NOT EXISTS `water_msg_message_all` (
  `msg_id` bigint(20) NOT NULL COMMENT '消息ID',
  `msg_key` varchar(40) COLLATE utf8mb4_general_ci NOT NULL,
  `trace_id` varchar(40) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '跟踪-guid',
  `tags` varchar(80) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `topic_name` varchar(40) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `content` varchar(999) COLLATE utf8mb4_general_ci NOT NULL COMMENT '内容（JSON格式）',
  `receive_url` varchar(200) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '定向接收目标',
  `receive_check` varchar(40) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '接收检查',
  `plan_time` timestamp NULL DEFAULT NULL,
  `state` int(11) NOT NULL DEFAULT '0' COMMENT '状态（-2无派发对象 ; -1:忽略；0:未处理；1处理中；2已完成；3派发超次数）',
  `dist_routed` tinyint(1) NOT NULL DEFAULT '0',
  `dist_count` int(11) NOT NULL DEFAULT '0' COMMENT '派发累记次数',
  `dist_nexttime` bigint(20) NOT NULL DEFAULT '0' COMMENT '下次派发时间',
  `log_date` int(11) NOT NULL DEFAULT '0' COMMENT '记录日期（yyyyMMdd）',
  `log_fulltime` bigint(20) NOT NULL COMMENT '记录时间',
  `last_date` int(11) NOT NULL DEFAULT '0',
  `last_fulltime` bigint(20)  COMMENT '最后变更时间',
  PRIMARY KEY (`msg_id`) USING BTREE,
  UNIQUE KEY `IX_key` (`msg_key`) USING BTREE,
  KEY `IX_state` (`state`) USING BTREE,
  KEY `IX_dist_count` (`dist_count`) USING BTREE,
  KEY `IX_log_date` (`log_date`) USING BTREE,
  KEY `IX_dist_nexttime` (`dist_nexttime`) USING BTREE,
  KEY `IX_topic_name` (`topic_name`) USING BTREE,
  KEY `IX_tags` (`tags`(40)) USING BTREE,
  KEY `IX_trace_id` (`trace_id`) USING BTREE,
  KEY `IX_last_date` (`last_date`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC COMMENT='WATER-消息-存储全表';