CREATE TABLE IF NOT EXISTS `${logger}` (
  `log_id` bigint(20) NOT NULL,
  `trace_id` varchar(40) COLLATE utf8mb4_general_ci COMMENT '跟踪-guid',
  `level` int(11) NOT NULL DEFAULT '0' COMMENT '级别',
  `tag` varchar(100) COLLATE utf8mb4_general_ci COMMENT '标签',
  `tag1` varchar(100) COLLATE utf8mb4_general_ci COMMENT '标签1',
  `tag2` varchar(100) COLLATE utf8mb4_general_ci COMMENT '标签2',
  `tag3` varchar(100) COLLATE utf8mb4_general_ci COMMENT '标签3',
  `tag4` varchar(100) COLLATE utf8mb4_general_ci COMMENT '标签4',
  `group` varchar(100) COLLATE utf8mb4_general_ci COMMENT '分组',
  `service` varchar(100) COLLATE utf8mb4_general_ci COMMENT '服务名',
  `class_name` varchar(512) COLLATE utf8mb4_general_ci COMMENT '类名',
  `thread_name` varchar(255) COLLATE utf8mb4_general_ci COMMENT '线程名',
  `content` longtext COLLATE utf8mb4_general_ci COMMENT '内容',
  `from` varchar(200) COLLATE utf8mb4_general_ci ,
  `log_date` int(11) NOT NULL DEFAULT '0' COMMENT '记录日期（yyyyMMdd）',
  `log_fulltime` bigint(20) NOT NULL,
  PRIMARY KEY (`log_id`) USING BTREE,
  KEY `IX_date` (`log_date`) USING BTREE,
  KEY `IX_tag` (`tag`) USING BTREE,
  KEY `IX_tag1` (`tag1`) USING BTREE,
  KEY `IX_tag2` (`tag2`) USING BTREE,
  KEY `IX_tag3` (`tag3`) USING BTREE,
  KEY `IX_tag4` (`tag4`) USING BTREE,
  KEY `IX_group` (`group`) USING BTREE,
  KEY `IX_service` (`service`) USING BTREE,
  KEY `IX_trace_id` (`trace_id`) USING BTREE,
  KEY `IX_log_fulltime` (`log_fulltime`) USING BTREE,
  KEY `IX_level` (`level`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;