/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.solon.config;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.impl.WxMaServiceHttpClientImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaServiceJoddHttpImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaServiceOkHttpImpl;
import cn.binarywang.wx.miniapp.config.WxMaConfig;
import cn.binarywang.wx.miniapp.solon.enums.HttpClientType;
import cn.binarywang.wx.miniapp.solon.properties.WxMaProperties;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Condition;
import org.noear.solon.annotation.Configuration;

@Configuration
public class WxMaServiceAutoConfiguration {
    @Bean
    @Condition(onMissingBean=WxMaService.class)
    public WxMaService wxMaService(WxMaConfig wxMaConfig, WxMaProperties wxMaProperties) {
        WxMaServiceOkHttpImpl wxMaService;
        HttpClientType httpClientType = wxMaProperties.getConfigStorage().getHttpClientType();
        switch (httpClientType) {
            case OkHttp: {
                wxMaService = new WxMaServiceOkHttpImpl();
                break;
            }
            case JoddHttp: {
                wxMaService = new WxMaServiceJoddHttpImpl();
                break;
            }
            case HttpClient: {
                wxMaService = new WxMaServiceHttpClientImpl();
                break;
            }
            default: {
                wxMaService = new WxMaServiceImpl();
            }
        }
        wxMaService.setWxMaConfig(wxMaConfig);
        return wxMaService;
    }
}

