/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.solon.config;

import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.impl.WxMpServiceHttpClientImpl;
import me.chanjar.weixin.mp.api.impl.WxMpServiceImpl;
import me.chanjar.weixin.mp.api.impl.WxMpServiceJoddHttpImpl;
import me.chanjar.weixin.mp.api.impl.WxMpServiceOkHttpImpl;
import me.chanjar.weixin.mp.config.WxMpConfigStorage;
import me.chanjar.weixin.mp.solon.enums.HttpClientType;
import me.chanjar.weixin.mp.solon.properties.WxMpProperties;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Condition;
import org.noear.solon.annotation.Configuration;

@Configuration
public class WxMpServiceAutoConfiguration {
    @Bean
    @Condition(onMissingBean=WxMpService.class)
    public WxMpService wxMpService(WxMpConfigStorage configStorage, WxMpProperties wxMpProperties) {
        WxMpService wxMpService;
        HttpClientType httpClientType = wxMpProperties.getConfigStorage().getHttpClientType();
        switch (httpClientType) {
            case OkHttp: {
                wxMpService = this.newWxMpServiceOkHttpImpl();
                break;
            }
            case JoddHttp: {
                wxMpService = this.newWxMpServiceJoddHttpImpl();
                break;
            }
            case HttpClient: {
                wxMpService = this.newWxMpServiceHttpClientImpl();
                break;
            }
            default: {
                wxMpService = this.newWxMpServiceImpl();
            }
        }
        wxMpService.setWxMpConfigStorage(configStorage);
        return wxMpService;
    }

    private WxMpService newWxMpServiceImpl() {
        return new WxMpServiceImpl();
    }

    private WxMpService newWxMpServiceHttpClientImpl() {
        return new WxMpServiceHttpClientImpl();
    }

    private WxMpService newWxMpServiceOkHttpImpl() {
        return new WxMpServiceOkHttpImpl();
    }

    private WxMpService newWxMpServiceJoddHttpImpl() {
        return new WxMpServiceJoddHttpImpl();
    }
}

