/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.open.solon.config.storage;

import me.chanjar.weixin.common.redis.RedissonWxRedisOps;
import me.chanjar.weixin.common.redis.WxRedisOps;
import me.chanjar.weixin.open.api.WxOpenConfigStorage;
import me.chanjar.weixin.open.api.impl.WxOpenInMemoryConfigStorage;
import me.chanjar.weixin.open.api.impl.WxOpenInRedisConfigStorage;
import me.chanjar.weixin.open.solon.config.storage.AbstractWxOpenConfigStorageConfiguration;
import me.chanjar.weixin.open.solon.properties.RedisProperties;
import me.chanjar.weixin.open.solon.properties.WxOpenProperties;
import org.apache.commons.lang3.StringUtils;
import org.noear.solon.Solon;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Condition;
import org.noear.solon.annotation.Configuration;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.TransportMode;

@Configuration
@Condition(onProperty="${wx.open.config-storage.type}=redisson", onClass=RedissonClient.class)
public class WxOpenInRedissonConfigStorageConfiguration
extends AbstractWxOpenConfigStorageConfiguration {
    @Bean
    @Condition(onMissingBean=WxOpenConfigStorage.class)
    public WxOpenConfigStorage wxOpenConfigStorage(WxOpenProperties properties) {
        WxOpenInRedisConfigStorage config = this.getWxOpenInRedissonConfigStorage(properties);
        return this.config((WxOpenInMemoryConfigStorage)config, properties);
    }

    private WxOpenInRedisConfigStorage getWxOpenInRedissonConfigStorage(WxOpenProperties properties) {
        RedisProperties redisProperties = properties.getConfigStorage().getRedis();
        RedissonClient redissonClient = redisProperties != null && StringUtils.isNotEmpty((CharSequence)redisProperties.getHost()) ? this.getRedissonClient(properties) : (RedissonClient)Solon.context().getBean(RedissonClient.class);
        RedissonWxRedisOps redisOps = new RedissonWxRedisOps(redissonClient);
        return new WxOpenInRedisConfigStorage((WxRedisOps)redisOps, properties.getConfigStorage().getKeyPrefix());
    }

    private RedissonClient getRedissonClient(WxOpenProperties properties) {
        WxOpenProperties.ConfigStorage storage = properties.getConfigStorage();
        RedisProperties redis = storage.getRedis();
        Config config = new Config();
        config.useSingleServer().setAddress("redis://" + redis.getHost() + ":" + redis.getPort()).setDatabase(redis.getDatabase()).setPassword(redis.getPassword());
        config.setTransportMode(TransportMode.NIO);
        return Redisson.create((Config)config);
    }
}

