/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.qidian.solon.config.storage;

import me.chanjar.weixin.qidian.config.WxQidianConfigStorage;
import me.chanjar.weixin.qidian.config.impl.WxQidianDefaultConfigImpl;
import me.chanjar.weixin.qidian.config.impl.WxQidianRedissonConfigImpl;
import me.chanjar.weixin.qidian.solon.config.storage.AbstractWxQidianConfigStorageConfiguration;
import me.chanjar.weixin.qidian.solon.properties.RedisProperties;
import me.chanjar.weixin.qidian.solon.properties.WxQidianProperties;
import org.apache.commons.lang3.StringUtils;
import org.noear.solon.Solon;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Condition;
import org.noear.solon.annotation.Configuration;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.TransportMode;

@Configuration
@Condition(onProperty="${wx.qidian.config-storage.type}=redisson", onClass=Redisson.class)
public class WxQidianInRedissonConfigStorageConfiguration
extends AbstractWxQidianConfigStorageConfiguration {
    @Bean
    @Condition(onMissingBean=WxQidianConfigStorage.class)
    public WxQidianConfigStorage WxMpConfigStorage(WxQidianProperties properties) {
        WxQidianRedissonConfigImpl config = this.redissonConfigStorage(properties);
        return this.config((WxQidianDefaultConfigImpl)config, properties);
    }

    private WxQidianRedissonConfigImpl redissonConfigStorage(WxQidianProperties properties) {
        RedisProperties redisProperties = properties.getConfigStorage().getRedis();
        RedissonClient redissonClient = redisProperties != null && StringUtils.isNotEmpty((CharSequence)redisProperties.getHost()) ? this.getRedissonClient(properties) : (RedissonClient)Solon.context().getBean(RedissonClient.class);
        return new WxQidianRedissonConfigImpl(redissonClient, properties.getConfigStorage().getKeyPrefix());
    }

    private RedissonClient getRedissonClient(WxQidianProperties properties) {
        WxQidianProperties.ConfigStorage storage = properties.getConfigStorage();
        RedisProperties redis = storage.getRedis();
        Config config = new Config();
        config.useSingleServer().setAddress("redis://" + redis.getHost() + ":" + redis.getPort()).setDatabase(redis.getDatabase()).setPassword(redis.getPassword());
        config.setTransportMode(TransportMode.NIO);
        return Redisson.create((Config)config);
    }
}

