/*
 * Decompiled with CFR 0.152.
 */
package org.noear.wood.generator.entity;

import java.io.File;
import java.io.FileWriter;
import java.util.List;
import org.noear.wood.DbContext;
import org.noear.wood.generator.entity.XmlParser;
import org.noear.wood.generator.entity.block.TableItem;
import org.noear.wood.generator.entity.block.XmlEntityBlock;
import org.noear.wood.generator.entity.block.XmlSourceBlock;
import org.noear.wood.generator.utils.NamingUtils;
import org.noear.wood.generator.utils.StringUtils;
import org.noear.wood.generator.utils.XmlUtils;
import org.noear.wood.wrap.ColumnWrap;
import org.noear.wood.wrap.SqlTypeUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlEntityGenerator {
    public static void generate(File baseDir, File sourceDir) {
        try {
            String path = baseDir.getAbsolutePath() + "/src/main/resources/wood-generator.xml";
            File file = new File(path);
            if (!file.exists()) {
                System.err.println("[Wood] No configuration file: wood-generator.xml");
            }
            XmlEntityGenerator.generate0(file, sourceDir);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    private static void generate0(File file, File sourceDir) throws Exception {
        Document doc = XmlUtils.parseDoc(file);
        Element nm = doc.getDocumentElement();
        NodeList nl = nm.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node n1 = nl.item(i);
            if (n1.getNodeType() != 1) continue;
            XmlEntityGenerator.generate1(n1, sourceDir);
        }
    }

    private static void generate1(Node n1, File sourceDir) throws Exception {
        XmlSourceBlock source = XmlParser.getSource(n1);
        if (source == null) {
            return;
        }
        if (!StringUtils.isEmpty(source.driverClassName)) {
            Class.forName(source.driverClassName);
        }
        DbContext db = new DbContext(source.schema, source.url, source.username, source.password);
        List<TableItem> tableItems = XmlParser.getTables(source, db);
        for (XmlEntityBlock entityBlock : source.entityBlocks) {
            if (entityBlock.code == null) continue;
            for (TableItem tableItem : tableItems) {
                XmlEntityGenerator.generateJavaFile(source, entityBlock, tableItem, sourceDir);
            }
        }
    }

    private static void generateJavaFile(XmlSourceBlock source, XmlEntityBlock entityBlock, TableItem tableItem, File sourceDir) throws Exception {
        String tmp;
        String tableName = tableItem.tableName;
        String domainName = tableItem.domainName;
        String entityName = entityBlock.entityName.replace("${domainName}", domainName);
        StringBuilder sb = new StringBuilder();
        sb.append("package ").append(entityBlock.targetPackage).append(";").append("\n\n");
        String code = entityBlock.code;
        code = code.replace("${entityName}", entityName);
        code = code.replace("${domainName}", domainName);
        code = code.replace("${tableName}", tableName);
        if (code.contains("${fields}")) {
            tmp = XmlEntityGenerator.buildFields(source, tableItem, false);
            code = code.replace("${fields}", tmp);
        }
        if (code.contains("${fields_public}")) {
            tmp = XmlEntityGenerator.buildFields(source, tableItem, true);
            code = code.replace("${fields_public}", tmp);
        }
        if (code.contains("${fields_getter}")) {
            tmp = XmlEntityGenerator.buildFieldsGetter(source, tableItem);
            code = code.replace("${fields_getter}", tmp);
        }
        if (code.contains("${fields_setter}")) {
            tmp = XmlEntityGenerator.buildFieldsSetter(source, tableItem);
            code = code.replace("${fields_setter}", tmp);
        }
        if (code.contains(" Date ")) {
            sb.append("import java.util.Date;").append("\n");
        }
        if (code.contains(" BigDecimal ")) {
            sb.append("import java.math.BigDecimal;").append("\n");
        }
        if (code.contains("BaseMapper<")) {
            sb.append("import org.noear.wood.BaseMapper;").append("\n");
        }
        if (code.contains("@Db(") || code.contains("@Table(")) {
            sb.append("import org.noear.wood.annotation.*;").append("\n");
        }
        sb.append(code);
        String dir = sourceDir.getAbsolutePath() + "/" + entityBlock.targetPackage.replace(".", "/") + "/";
        XmlEntityGenerator.createFile(dir, entityName, sb.toString());
    }

    private static void createFile(String dir, String fileName, String fileContent) throws Exception {
        String fileFullName;
        File file;
        File dir2 = new File(dir);
        if (!dir2.exists()) {
            dir2.mkdirs();
        }
        if ((file = new File(fileFullName = dir + fileName + ".java")).exists()) {
            file.delete();
        }
        file.createNewFile();
        try (FileWriter fw = new FileWriter(file);){
            fw.write(fileContent);
        }
        System.out.println("[Wood] Generated : " + file.getAbsolutePath());
    }

    private static String buildFields(XmlSourceBlock source, TableItem table, boolean usePublic) {
        StringBuilder sb = new StringBuilder();
        boolean camel = "camel".equals(source.namingStyle);
        for (ColumnWrap cw : table.tableWrap.getColumns()) {
            XmlEntityGenerator.buildColumnRemarks(cw, sb);
            if (table.tableWrap.getPks().contains(cw.getName())) {
                sb.append("@PrimaryKey").append("\n");
            }
            if (usePublic) {
                sb.append("  public ");
            } else {
                sb.append("  private ");
            }
            sb.append(SqlTypeUtil.getJavaType((ColumnWrap)cw, (boolean)source.typeStyle.startsWith("base"))).append(" ");
            if (camel) {
                sb.append(NamingUtils.toCamelString(cw.getName()));
            } else {
                sb.append(cw.getName());
            }
            sb.append(";").append("\n");
        }
        return sb.toString();
    }

    private static String buildFieldsGetter(XmlSourceBlock source, TableItem table) {
        StringBuilder sb = new StringBuilder();
        boolean camel = "camel".equals(source.namingStyle);
        for (ColumnWrap cw : table.tableWrap.getColumns()) {
            XmlEntityGenerator.buildColumnRemarks(cw, sb);
            sb.append("  public ").append(SqlTypeUtil.getJavaType((ColumnWrap)cw, (boolean)source.typeStyle.startsWith("base"))).append(" get");
            if (camel) {
                sb.append(NamingUtils.toCamelString(cw.getName(), true));
            } else {
                sb.append(NamingUtils.capitalize(cw.getName()));
            }
            sb.append("(){\n");
            sb.append("  return ");
            if (camel) {
                sb.append(NamingUtils.toCamelString(cw.getName()));
            } else {
                sb.append(cw.getName());
            }
            sb.append(";\n");
            sb.append("  }\n");
            sb.append("\n");
        }
        return sb.toString();
    }

    private static String buildFieldsSetter(XmlSourceBlock source, TableItem table) {
        StringBuilder sb = new StringBuilder();
        boolean camel = "camel".equals(source.namingStyle);
        for (ColumnWrap cw : table.tableWrap.getColumns()) {
            XmlEntityGenerator.buildColumnRemarks(cw, sb);
            sb.append("  public void set");
            if (camel) {
                sb.append(NamingUtils.toCamelString(cw.getName(), true));
            } else {
                sb.append(NamingUtils.capitalize(cw.getName()));
            }
            sb.append("(").append(SqlTypeUtil.getJavaType((ColumnWrap)cw, (boolean)source.typeStyle.startsWith("base"))).append(" val){\n");
            sb.append("  ");
            if (camel) {
                sb.append(NamingUtils.toCamelString(cw.getName()));
            } else {
                sb.append(cw.getName());
            }
            sb.append(" = val;\n");
            sb.append("  }\n");
            sb.append("\n");
        }
        return sb.toString();
    }

    private static void buildColumnRemarks(ColumnWrap cw, StringBuilder sb) {
        if (!StringUtils.isEmpty(cw.getRemarks())) {
            String remarks = cw.getRemarks().replace("\r\n", " ").replace("\n", " ");
            sb.append("  /** ").append(remarks).append(" */\n");
        }
    }
}

