/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.zookeeper.service;

import java.util.List;
import org.noear.snack.ONode;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudDiscoveryHandler;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.extend.zookeeper.impl.ZkClient;
import org.noear.solon.cloud.model.Discovery;
import org.noear.solon.cloud.model.Instance;
import org.noear.solon.cloud.service.CloudDiscoveryObserverEntity;
import org.noear.solon.cloud.service.CloudDiscoveryService;

public class CloudDiscoveryServiceZkImp
implements CloudDiscoveryService {
    private static final String PATH_ROOT = "/solon/register";
    private ZkClient client;

    public CloudDiscoveryServiceZkImp(CloudProps cloudProps) {
        String sessionTimeout = cloudProps.getDiscoveryHealthCheckInterval("3000");
        this.client = new ZkClient(cloudProps.getDiscoveryServer(), Integer.parseInt(sessionTimeout));
        this.client.connectServer();
        this.client.createNode("/solon");
        this.client.createNode(PATH_ROOT);
    }

    public void register(String group, Instance instance) {
        this.registerState(group, instance, true);
    }

    public void registerState(String group, Instance instance, boolean health) {
        if (health) {
            this.client.createNode(String.format("%s/%s", PATH_ROOT, group));
            this.client.createNode(String.format("%s/%s/%s", PATH_ROOT, group, instance.service()));
            String info = ONode.stringify((Object)instance);
            this.client.createNode(String.format("%s/%s/%s/%s", PATH_ROOT, group, instance.service(), instance.address()), info, false);
        } else {
            this.deregister(group, instance);
        }
    }

    public void deregister(String group, Instance instance) {
        this.client.removeNode(String.format("%s/%s/%s/%s", PATH_ROOT, group, instance.service(), instance.address()));
    }

    public Discovery find(String group, String service) {
        if (Utils.isEmpty((String)group)) {
            group = Solon.cfg().appGroup();
        }
        Discovery discovery = new Discovery(service);
        List<String> nodeDataList = this.client.findChildrenNode(String.format("%s/%s/%s", PATH_ROOT, group, service));
        for (String v : nodeDataList) {
            Instance instance = (Instance)ONode.deserialize((String)v, Instance.class);
            discovery.instanceAdd(instance);
        }
        return discovery;
    }

    public void attention(String group, String service, CloudDiscoveryHandler observer) {
        if (Utils.isEmpty((String)group)) {
            group = Solon.cfg().appGroup();
        }
        CloudDiscoveryObserverEntity entity = new CloudDiscoveryObserverEntity(group, service, observer);
        this.client.watchChildrenNode(String.format("%s/%s/%s", PATH_ROOT, group, service), event -> {
            Discovery discovery = this.find(entity.group, service);
            entity.handle(discovery);
        });
    }

    public void close() throws InterruptedException {
        if (this.client != null) {
            this.client.close();
        }
    }
}

