/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.model;

import org.nuiton.jredmine.model.Attachment;
import org.nuiton.jredmine.model.Issue;
import org.nuiton.jredmine.model.IssueCategory;
import org.nuiton.jredmine.model.IssuePriority;
import org.nuiton.jredmine.model.IssueStatus;
import org.nuiton.jredmine.model.News;
import org.nuiton.jredmine.model.Project;
import org.nuiton.jredmine.model.RedmineModelScope;
import org.nuiton.jredmine.model.Tracker;
import org.nuiton.jredmine.model.User;
import org.nuiton.jredmine.model.Version;

public enum RedmineModelEnum {
    issueStatus(IssueStatus.class, RedmineModelScope.none),
    issuePriority(IssuePriority.class, RedmineModelScope.none),
    project(Project.class, RedmineModelScope.none),
    issueCategory(IssueCategory.class, RedmineModelScope.project),
    tracker(Tracker.class, RedmineModelScope.project),
    user(User.class, RedmineModelScope.project),
    news(News.class, RedmineModelScope.project),
    version(Version.class, RedmineModelScope.project),
    issue(Issue.class, RedmineModelScope.version),
    attachment(Attachment.class, RedmineModelScope.version);

    private final Class<?> modelType;
    private final RedmineModelScope scope;

    private RedmineModelEnum(Class<?> modelType, RedmineModelScope scope) {
        this.modelType = modelType;
        this.scope = scope;
    }

    public Class<?> getModelType() {
        return this.modelType;
    }

    public RedmineModelScope getScope() {
        return this.scope;
    }

    public static RedmineModelEnum valueOf(Class<?> type) {
        for (RedmineModelEnum e : RedmineModelEnum.values()) {
            if (type != e.getModelType()) continue;
            return e;
        }
        return null;
    }

    public static RedmineModelEnum safeValueOf(Class<?> type) {
        if (type == null) {
            throw new NullPointerException("klass parameter can not be null");
        }
        RedmineModelEnum r = RedmineModelEnum.valueOf(type);
        if (r == null) {
            throw new IllegalArgumentException("the type " + type.getName() + " is not allowed!");
        }
        return r;
    }
}

