/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.integration.quartz;

import org.nutz.integration.quartz.Quartzs;
import org.nutz.integration.quartz.annotation.Scheduled;
import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.resource.Scans;
import org.quartz.JobDataMap;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;

public class NutQuartzCronJobFactory {
    private static final Log log = Logs.get();
    protected PropertiesProxy conf;
    protected Scheduler scheduler;

    public void init() throws Exception {
        String prefix = "cron.";
        for (String key : this.conf.getKeys()) {
            if (key.length() < prefix.length() + 1 || !key.startsWith(prefix)) continue;
            String name = key.substring(prefix.length());
            if ("pkgs".equals(name)) {
                log.debug((Object)("found cron job packages = " + this.conf.get(key)));
                for (String pkg : Strings.splitIgnoreBlank((String)this.conf.get(key), (String)",")) {
                    this.addPackage(pkg);
                }
                continue;
            }
            String cron = this.conf.get(key);
            log.debugf("job define name=%s cron=%s", new Object[]{name, cron});
            Class klass = null;
            klass = name.contains(".") ? Lang.loadClass((String)name) : Lang.loadClass((String)(this.getClass().getPackage().getName() + ".job." + name));
            Quartzs.cron(this.scheduler, cron, klass);
        }
    }

    public void addPackage(String pkg) {
        for (Class klass : Scans.me().scanPackage(pkg)) {
            Scheduled scheduled = klass.getAnnotation(Scheduled.class);
            if (scheduled == null) continue;
            try {
                this.add(klass, scheduled);
            }
            catch (SchedulerException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void add(Class<?> klass, Scheduled scheduled) throws SchedulerException {
        String name = klass.getName();
        if (!Strings.isBlank((CharSequence)scheduled.cron())) {
            log.debugf("job define name=%s cron=%s", new Object[]{name, scheduled.cron()});
            Quartzs.cron(this.scheduler, scheduled.cron(), klass);
        } else if (scheduled.fixedRate() > 0) {
            log.debugf("job define name=%s fixedRate=%s count=%s initialDelay=%s", new Object[]{name, scheduled.fixedRate(), scheduled.count(), scheduled.initialDelay()});
            Quartzs.simple(this.scheduler, klass, scheduled.fixedRate(), scheduled.count(), scheduled.initialDelay());
        }
    }

    public void add(Class<?> klass, String cron, JobDataMap data, String jobKeyName, String jobKeyGroup) throws SchedulerException {
        String name = klass.getName();
        if (!Strings.isBlank((CharSequence)cron)) {
            log.debugf("job define name=%s cron=%s", new Object[]{name, cron});
            Quartzs.cron(this.scheduler, cron, klass, data, jobKeyName, jobKeyGroup);
        }
    }
}

