/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.integration.quartz;

import org.nutz.dao.entity.annotation.Column;
import org.nutz.dao.entity.annotation.Id;
import org.nutz.dao.entity.annotation.Table;
import org.nutz.integration.quartz.Quartzs;
import org.nutz.json.Json;
import org.nutz.json.JsonFormat;
import org.nutz.lang.Strings;
import org.nutz.lang.util.NutMap;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerKey;

@Table(value="t_quartz_job")
public class QuartzJob {
    @Id
    protected int id;
    @Column(value="jn")
    protected String jobName;
    @Column(value="jg")
    protected String jobGroup;
    @Column
    protected String cron;
    @Column
    protected String scheduled;
    @Column(value="klass")
    protected String className;
    @Column(value="dm")
    protected String dataMap;
    @Column(value="cm")
    protected String comment;

    public QuartzJob() {
    }

    public QuartzJob(JobKey jobKey, Trigger trigger, JobDetail jobDetail) {
        this.setJobKey(jobKey);
        this.setTrigger(trigger);
        this.className = jobDetail.getJobClass().getName();
        this.dataMap = Json.toJson((Object)jobDetail.getJobDataMap(), (JsonFormat)JsonFormat.compact());
    }

    public void setJobKey(JobKey jobKey) {
        this.setJobName(jobKey.getName());
        this.setJobGroup(jobKey.getGroup());
    }

    public JobKey getJobKey() {
        return JobKey.jobKey((String)this.jobName, (String)this.jobGroup);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobGroup() {
        return this.jobGroup;
    }

    public void setJobGroup(String jobGroup) {
        this.jobGroup = jobGroup;
    }

    public String getCron() {
        return this.cron;
    }

    public void setCron(String cron) {
        this.cron = cron;
    }

    public String getScheduled() {
        return this.scheduled;
    }

    public void setScheduled(String schedule) {
        this.scheduled = schedule;
    }

    public Trigger getTrigger() {
        if (Strings.isBlank((CharSequence)this.cron)) {
            NutMap map = (NutMap)Json.fromJson(NutMap.class, (CharSequence)this.scheduled);
            return Quartzs.makeSimpleTrigger(this.jobName, this.jobGroup, map.getInt("rate"), map.getInt("count"), map.getLong("delay"), map.getTime("startTime"), map.getTime("endTime"));
        }
        return Quartzs.makeCronTrigger(this.jobName, this.jobGroup, this.cron);
    }

    public void setTrigger(Trigger trigger) {
        if (trigger instanceof CronTrigger) {
            this.cron = ((CronTrigger)trigger).getCronExpression();
        } else if (trigger instanceof SimpleTrigger) {
            NutMap tmp = new NutMap();
            SimpleTrigger st = (SimpleTrigger)trigger;
            tmp.put((Object)"rate", (Object)st.getRepeatInterval());
            tmp.put((Object)"count", (Object)st.getRepeatCount());
            tmp.put((Object)"startTime", (Object)st.getStartTime());
            tmp.put((Object)"endTime", (Object)st.getEndTime());
            this.scheduled = Json.toJson((Object)tmp, (JsonFormat)JsonFormat.compact());
        }
    }

    public TriggerKey getTriggerKey() {
        return new TriggerKey(this.jobName, this.jobGroup);
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getDataMap() {
        return this.dataMap;
    }

    public void setDataMap(String dataMap) {
        this.dataMap = dataMap;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }
}

