/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.integration.quartz;

import java.util.Date;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

public class Quartzs {
    public static void cron(Scheduler scheduler, String cron, Class<?> klass) {
        try {
            String name = klass.getName();
            String group = "DEFAULT";
            JobKey jobKey = new JobKey(name, group);
            if (scheduler.checkExists(jobKey)) {
                scheduler.deleteJob(jobKey);
            }
            scheduler.scheduleJob(Quartzs.makeJob(jobKey, klass), (Trigger)Quartzs.makeCronTrigger(name, group, cron));
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    public static void cron(Scheduler scheduler, String cron, Class<?> klass, JobDataMap data, String name, String group) {
        try {
            JobKey jobKey = new JobKey(name, group);
            if (scheduler.checkExists(jobKey)) {
                scheduler.deleteJob(jobKey);
            }
            scheduler.scheduleJob(Quartzs.makeJob(jobKey, klass, data), (Trigger)Quartzs.makeCronTrigger(name, group, cron));
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    public static void simple(Scheduler scheduler, Class<?> klass, int fixedRate, int count, long initialDelay) {
        Quartzs.simple(scheduler, klass, fixedRate, count, initialDelay, null, null);
    }

    public static void simple(Scheduler scheduler, Class<?> klass, int fixedRate, int count, long initialDelay, Date startTime, Date endTime) {
        try {
            String name = klass.getName();
            String group = "DEFAULT";
            JobKey jobKey = new JobKey(name, group);
            if (scheduler.checkExists(jobKey)) {
                scheduler.deleteJob(jobKey);
            }
            scheduler.scheduleJob(Quartzs.makeJob(jobKey, klass), (Trigger)Quartzs.makeSimpleTrigger(name, group, fixedRate, count, initialDelay, startTime, endTime));
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    public static CronTrigger makeCronTrigger(String jobName, String jobGroup, String cron) {
        return (CronTrigger)TriggerBuilder.newTrigger().withIdentity(jobName, jobGroup).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron)).build();
    }

    public static SimpleTrigger makeSimpleTrigger(String jobName, String jobGroup, int fixedRate, int count, long initialDelay) {
        return Quartzs.makeSimpleTrigger(jobName, jobGroup, fixedRate, count, initialDelay, null, null);
    }

    public static SimpleTrigger makeSimpleTrigger(String jobName, String jobGroup, int fixedRate, int count, long initialDelay, Date startTime, Date endTime) {
        SimpleScheduleBuilder schedule = SimpleScheduleBuilder.simpleSchedule();
        if (fixedRate > 0) {
            schedule.withIntervalInSeconds(fixedRate / 1000);
        }
        if (count > 0) {
            schedule.withRepeatCount(count);
        } else {
            schedule.repeatForever();
        }
        TriggerBuilder trigger = TriggerBuilder.newTrigger().withIdentity(jobName, jobGroup).withSchedule((ScheduleBuilder)schedule);
        if (startTime != null) {
            trigger.startAt(startTime);
        }
        if (endTime != null) {
            trigger.endAt(endTime);
        }
        if (initialDelay > 0L) {
            trigger.startAt(new Date(System.currentTimeMillis() + initialDelay * 1000L));
        }
        return (SimpleTrigger)trigger.build();
    }

    public static JobDetail makeJob(String jobName, String jobGroup, Class<?> klass) {
        return Quartzs.makeJob(new JobKey(jobName, jobGroup), klass);
    }

    public static JobDetail makeJob(String jobName, String jobGroup, Class<?> klass, JobDataMap data) {
        return Quartzs.makeJob(new JobKey(jobName, jobGroup), klass, data);
    }

    public static JobDetail makeJob(JobKey jobKey, Class<?> klass) {
        return Quartzs.makeJob(jobKey, klass, null);
    }

    public static JobDetail makeJob(JobKey jobKey, Class<?> klass, JobDataMap data) {
        if (data == null) {
            data = new JobDataMap();
        }
        JobBuilder jb = JobBuilder.newJob(klass).withIdentity(jobKey);
        if (data != null) {
            try {
                jb.setJobData(data);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        return jb.build();
    }
}

