/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.plugins.apidoc;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.json.JsonFormat;
import org.nutz.lang.ContinueLoop;
import org.nutz.lang.Each;
import org.nutz.lang.Encoding;
import org.nutz.lang.ExitLoop;
import org.nutz.lang.Lang;
import org.nutz.lang.LoopException;
import org.nutz.lang.Mirror;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;
import org.nutz.lang.Times;
import org.nutz.lang.util.ClassMeta;
import org.nutz.lang.util.ClassMetaReader;
import org.nutz.lang.util.NutMap;
import org.nutz.lang.util.SimpleContext;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.ActionChainMaker;
import org.nutz.mvc.ActionContext;
import org.nutz.mvc.ActionInfo;
import org.nutz.mvc.Mvcs;
import org.nutz.mvc.NutConfig;
import org.nutz.mvc.ObjectInfo;
import org.nutz.mvc.View;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Fail;
import org.nutz.mvc.annotation.Param;
import org.nutz.mvc.impl.ActionInvoker;
import org.nutz.mvc.impl.UrlMappingImpl;
import org.nutz.mvc.view.RawView;
import org.nutz.mvc.view.UTF8JsonView;
import org.nutz.plugins.apidoc.annotation.Api;
import org.nutz.plugins.apidoc.annotation.ApiMatchMode;
import org.nutz.plugins.apidoc.annotation.ApiParam;
import org.nutz.plugins.apidoc.annotation.Manual;
import org.nutz.plugins.apidoc.annotation.ReturnKey;

public class ApidocUrlMapping
extends UrlMappingImpl {
    protected static LinkedHashMap<String, ExpClass> infos = new LinkedHashMap();
    protected NutMap projectInfo;
    private static final Log log = Logs.get();
    protected static String[] EMTRY = new String[0];
    protected String globalFailView;
    protected List<NutMap> defaultFails = new ArrayList<NutMap>();
    protected View view;
    protected ActionInvoker docInvoker;
    protected String expPath;
    protected ApiMatchMode baseMatchMode;
    protected NutMap cache;

    public ApidocUrlMapping() {
        this.defaultFails.add(NutMap.NEW().addv("key", (Object)404).addv("description", (Object)"Not Found"));
        this.defaultFails.add(NutMap.NEW().addv("key", (Object)403).addv("description", (Object)"Permission Denied"));
        this.defaultFails.add(NutMap.NEW().addv("key", (Object)500).addv("description", (Object)"Exception Occured"));
        this.view = new UTF8JsonView(JsonFormat.full());
        this.docInvoker = new DocActionInvoker();
        this.expPath = "/_/";
        this.baseMatchMode = ApiMatchMode.ONLY;
        this.cache = NutMap.NEW();
    }

    public void add(ActionChainMaker maker, ActionInfo ai, NutConfig nc) {
        super.add(maker, ai, nc);
        ExpContext ctx = new ExpContext();
        ctx.set("maker", maker);
        ctx.set("ai", ai);
        ctx.set("nc", nc);
        this._add(ctx);
        if (this.projectInfo == null) {
            Manual document;
            this.projectInfo = new NutMap();
            Fail fail = nc.getMainModule().getAnnotation(Fail.class);
            if (fail != null) {
                this.globalFailView = fail.value();
            }
            if ((document = nc.getMainModule().getAnnotation(Manual.class)) != null) {
                this.projectInfo.addv("name", (Object)document.name()).addv("description", (Object)document.description()).addv("author", (Object)document.author()).addv("email", (Object)document.email()).addv("homePage", (Object)document.homePage()).addv("copyright", (Object)document.copyRight());
            }
        }
    }

    public ActionInvoker get(ActionContext ac) {
        String path = Mvcs.getRequestPath((HttpServletRequest)ac.getRequest());
        if (path.startsWith(this.expPath)) {
            if (path.equals(this.expPath) || path.equals(this.expPath + "index")) {
                HttpServletResponse resp = ac.getResponse();
                resp.setCharacterEncoding("UTF-8");
                resp.setContentType("text/html");
                InputStream ins = ac.getServletContext().getResourceAsStream(this.expPath + "index.html");
                if (ins != null) {
                    String tmp = Streams.readAndClose((Reader)new InputStreamReader(ins, Encoding.CHARSET_UTF8));
                    ins = Strings.isBlank((CharSequence)tmp) ? null : ac.getServletContext().getResourceAsStream(this.expPath + "index.html");
                }
                if (ins == null) {
                    ins = ((Object)((Object)this)).getClass().getResourceAsStream("index.html");
                }
                try {
                    new RawView("html").render(ac.getRequest(), resp, (Object)ins);
                }
                catch (Throwable e) {
                    log.debug((Object)e.getMessage(), e);
                }
                return new EmtryActionInvoker();
            }
            if (path.equals(this.expPath + "exp")) {
                return this.docInvoker;
            }
        }
        return super.get(ac);
    }

    protected ExpMethod _add(ExpContext ctx) {
        Api api;
        String typeName = ctx.ai().getModuleType().getName();
        ExpClass expClass = infos.get(typeName);
        if (expClass == null) {
            expClass = this.makeClass(ctx.ai().getModuleType(), ctx);
            if (expClass == null) {
                log.trace((Object)"skip null ExpClass");
                return null;
            }
            infos.put(typeName, expClass);
        }
        ctx.set("expClass", (Object)expClass);
        ArrayList<ExpMethod> methods = (ArrayList<ExpMethod>)expClass.getAs("methods", List.class);
        if (methods == null) {
            methods = new ArrayList<ExpMethod>();
            expClass.put("methods", methods);
        }
        if ((api = ctx.ai().getMethod().getAnnotation(Api.class)) == null && expClass.getAs("apiMatchMode", ApiMatchMode.class) == ApiMatchMode.ONLY) {
            log.trace((Object)"skip null @Api Method");
            return null;
        }
        ExpMethod expMethod = this.makeMethod(ctx);
        if (expMethod == null) {
            log.trace((Object)"skip null ExpMethod");
            return null;
        }
        methods.add(expMethod);
        return expMethod;
    }

    protected ExpClass makeClass(Class<?> klass, ExpContext ctx) {
        At at;
        Api api = klass.getAnnotation(Api.class);
        if (api == null && this.baseMatchMode != ApiMatchMode.ALL) {
            return null;
        }
        if (api != null && api.match() == ApiMatchMode.NONE) {
            return null;
        }
        ExpClass expClass = new ExpClass();
        expClass.put("typeName", klass.getName());
        IocBean ib = klass.getAnnotation(IocBean.class);
        if (ib != null) {
            expClass.put("iocName", Strings.isBlank((CharSequence)ib.name()) ? Strings.lowerFirst((CharSequence)klass.getSimpleName()) : ib.name());
        }
        if (api != null) {
            expClass.put("name", api.name());
            expClass.put("description", api.description());
            expClass.put("apiMatchMode", (Object)api.match());
        }
        if (Strings.isBlank((CharSequence)expClass.getString("name"))) {
            expClass.put("name", klass.getSimpleName());
        }
        expClass.put("pathPrefixs", (at = klass.getAnnotation(At.class)) == null ? new String[]{} : at.value());
        InputStream ins = klass.getClassLoader().getResourceAsStream(klass.getName().replace(".", "/") + ".class");
        if (ins != null) {
            try {
                ClassMeta meta = ClassMetaReader.build((InputStream)ins);
                expClass.setv("meta", meta);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return expClass;
    }

    protected Object instance(Class clazz) {
        if (this.cache.get((Object)clazz.getName()) != null) {
            return this.cache.get((Object)clazz.getName());
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return 0;
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return 0;
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return 0.0;
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return 0;
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return 0L;
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return Float.valueOf(0.0f);
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            return Character.valueOf('a');
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return false;
        }
        if (clazz == String.class) {
            return "S";
        }
        if (clazz == Date.class) {
            return Times.now();
        }
        if (clazz == BigDecimal.class) {
            return new BigDecimal(0);
        }
        if (clazz == BigInteger.class) {
            return new BigInteger("1");
        }
        try {
            Field[] fields;
            Object obj = clazz.newInstance();
            this.cache.put((Object)clazz.getName(), obj);
            for (Field field : fields = Mirror.me((Class)clazz).getFields()) {
                if (field.getType() == clazz) continue;
                Object _obj = this.instance(field.getType());
                this.cache.put((Object)field.getType().getName(), _obj);
                Mirror.me((Class)clazz).setValue(obj, field.getName(), _obj);
            }
            return obj;
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            return null;
        }
    }

    protected ExpMethod makeMethod(ExpContext ctx) {
        String[] stringArray;
        ActionInfo ai = ctx.ai();
        ExpMethod expMethod = new ExpMethod();
        ctx.set("expMethod", (Object)expMethod);
        expMethod.put("chainName", ai.getChainName() == null ? "default" : ai.getChainName());
        expMethod.put("typeName", ai.getModuleType().getName());
        expMethod.put("okView", ai.getOkView());
        expMethod.put("failView", Strings.isBlank((CharSequence)ai.getFailView()) ? this.globalFailView : ai.getFailView());
        expMethod.put("lineNumber", ai.getLineNumber());
        expMethod.put("paths", ai.getPaths());
        expMethod.put("returnType", ai.getMethod().getReturnType().getName());
        expMethod.put("returnData", this.instance(ai.getMethod().getReturnType()));
        expMethod.put("methodName", ai.getMethod().getName());
        if (ai.getAdaptorInfo() != null) {
            expMethod.put("adaptorName", ai.getAdaptorInfo().getType().getName());
        }
        expMethod.put("requestBody", Strings.equals((String)expMethod.getString("adaptorName"), (String)"org.nutz.mvc.adaptor.JsonAdaptor"));
        if (ai.getHttpMethods() == null || ai.getHttpMethods().size() == 0) {
            if (Strings.equals((String)expMethod.getString("adaptorName"), (String)"org.nutz.mvc.adaptor.JsonAdaptor")) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "POST";
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "GET";
                stringArray = stringArray3;
                stringArray3[1] = "POST";
            }
        } else {
            stringArray = ai.getHttpMethods();
        }
        expMethod.put("httpMethods", stringArray);
        ObjectInfo[] filters = ai.getFilterInfos();
        if (filters == null) {
            expMethod.put("filters", EMTRY);
        } else {
            ArrayList<String> filterNames = new ArrayList<String>();
            for (ObjectInfo objectInfo : filters) {
                filterNames.add(objectInfo.getType().getSimpleName());
            }
            expMethod.put("filters", filterNames);
        }
        Api api = ai.getMethod().getAnnotation(Api.class);
        if (api != null) {
            expMethod.put("author", api.author());
            expMethod.put("name", api.name());
            expMethod.put("description", api.description());
        } else {
            expMethod.put("name", expMethod.get("methodName"));
        }
        expMethod.put("params", this.make(ai.getMethod(), expMethod, ctx));
        return expMethod;
    }

    protected ApiParam matchApiParam(List<ApiParam> params, int index, String name) {
        if (params == null || params.size() == 0) {
            return null;
        }
        for (ApiParam apiParam : params) {
            if (apiParam.index() != index && !Strings.equals((String)name, (String)apiParam.name())) continue;
            return apiParam;
        }
        return null;
    }

    protected List<ExpParam> make(Method method, ExpMethod expMethod, ExpContext ctx) {
        ArrayList data;
        ArrayList<ExpParam> params = new ArrayList<ExpParam>();
        String metaKey = ClassMetaReader.getKey((Object)method);
        expMethod.put("methodId", ctx.expClass().getString("typeName") + "#" + metaKey);
        ClassMeta meta = (ClassMeta)ctx.expClass().getAs("meta", ClassMeta.class);
        List paramNames = meta == null ? null : (List)meta.paramNames.get(metaKey);
        Api api = method.getAnnotation(Api.class);
        List apiParams = null;
        if (api != null) {
            apiParams = Lang.array2list((Object[])api.params());
        }
        Type[] types = method.getGenericParameterTypes();
        Annotation[][] annos = method.getParameterAnnotations();
        for (int i = 0; i < types.length; ++i) {
            Mirror mirror = Mirror.me((Type)types[i]);
            Class clazz = mirror.getType();
            if (clazz.isAssignableFrom(HttpServletRequest.class) || clazz.isAssignableFrom(HttpServletResponse.class) || clazz.isAssignableFrom(HttpSession.class) || clazz.isAssignableFrom(ServletContext.class)) continue;
            ExpParam expParam = new ExpParam();
            expParam.put("index", i);
            expParam.put("ignore", false);
            expParam.put("paramLocalName", paramNames.get(i));
            expParam.put("typeName", mirror.getType().getName());
            expParam.put("requestData", this.instance(clazz));
            for (Annotation anno : annos[i]) {
                if (!(anno instanceof Param)) continue;
                Param _param = (Param)anno;
                expParam.put("annoParamName", _param.value());
                expParam.put("annoParamDefault", _param.df());
                expParam.put("paramDefault", _param.df());
                expParam.put("annoParamDateFormat", _param.dfmt());
                expParam.put("paramDateFormat", _param.dfmt());
            }
            if (!Strings.isBlank((CharSequence)expParam.getString("annoParamName"))) {
                expParam.put("paramName", expParam.getString("annoParamName"));
            } else {
                expParam.put("paramName", expParam.getString("paramLocalName"));
            }
            ApiParam apiParam = this.matchApiParam(apiParams, i, expParam.getString("paramName"));
            if (apiParam != null) {
                if (apiParam.index() != -1) {
                    expParam.put("index", apiParam.index());
                }
                if (Strings.isBlank((CharSequence)apiParam.name())) {
                    expParam.put("paramName", apiParam.name());
                }
                expParam.put("ignore", apiParam.ignore());
                expParam.put("description", apiParam.description());
                if (!Strings.isBlank((CharSequence)apiParam.type())) {
                    expParam.put("typeName", apiParam.type());
                }
                if (!Strings.isBlank((CharSequence)apiParam.defaultValue())) {
                    expParam.put("paramDefault", apiParam.defaultValue());
                }
                if (!Strings.isBlank((CharSequence)apiParam.dateFormat())) {
                    expParam.put("paramDateFormat", apiParam.dateFormat());
                }
                expParam.put("optional", apiParam.optional());
                if (!Strings.isBlank((CharSequence)apiParam.requestData())) {
                    expParam.put("requestData", apiParam.requestData());
                }
                apiParams.remove(apiParam);
            }
            params.add(expParam);
        }
        if (apiParams != null) {
            for (ApiParam apiParam : apiParams) {
                ExpParam expParam = new ExpParam();
                expParam.put("requestData", apiParam.requestData());
                if (apiParam.index() != -1) {
                    expParam.put("index", apiParam.index());
                }
                if (Strings.isBlank((CharSequence)apiParam.name())) {
                    expParam.put("paramName", apiParam.name());
                }
                expParam.put("ignore", apiParam.ignore());
                expParam.put("paramName", apiParam.name());
                expParam.put("description", apiParam.description());
                if (!Strings.isBlank((CharSequence)apiParam.type())) {
                    expParam.put("typeName", apiParam.type());
                }
                if (!Strings.isBlank((CharSequence)apiParam.defaultValue())) {
                    expParam.put("paramDefault", apiParam.defaultValue());
                }
                if (!Strings.isBlank((CharSequence)apiParam.dateFormat())) {
                    expParam.put("paramDateFormat", apiParam.dateFormat());
                }
                expParam.put("optional", apiParam.optional());
                params.add(expParam);
            }
        }
        ReturnKey[] oks = null;
        ReturnKey[] fails = null;
        if (api != null) {
            oks = api.ok();
            fails = api.fail();
        }
        if (oks != null) {
            data = new ArrayList();
            Lang.each((Object)oks, (Each)new Each<ReturnKey>(){

                public void invoke(int index, ReturnKey key, int length) throws ExitLoop, ContinueLoop, LoopException {
                    NutMap temp = NutMap.NEW();
                    temp.put((Object)"key", (Object)key.key());
                    temp.put((Object)"description", (Object)key.description());
                    data.add(temp);
                }
            });
            expMethod.put("oks", data);
        }
        if (fails != null && fails.length != 0) {
            data = new ArrayList();
            Lang.each((Object)fails, (Each)new Each<ReturnKey>(){

                public void invoke(int index, ReturnKey key, int length) throws ExitLoop, ContinueLoop, LoopException {
                    NutMap temp = NutMap.NEW();
                    temp.put((Object)"key", (Object)key.key());
                    temp.put((Object)"description", (Object)key.description());
                    data.add(temp);
                }
            });
            expMethod.put("fails", data);
        } else {
            expMethod.put("fails", this.defaultFails);
        }
        return params;
    }

    protected static class ExpContext
    extends SimpleContext {
        protected ExpContext() {
        }

        public NutConfig nc() {
            return (NutConfig)this.getAs(NutConfig.class, "nc");
        }

        public ExpClass expClass() {
            return (ExpClass)((Object)this.getAs(ExpClass.class, "expClass"));
        }

        public ExpMethod expMethod() {
            return (ExpMethod)((Object)this.getAs(ExpMethod.class, "expMethod"));
        }

        public ActionInfo ai() {
            return (ActionInfo)this.getAs(ActionInfo.class, "ai");
        }
    }

    protected static class ExpParam
    extends NutMap {
        private static final long serialVersionUID = 1L;

        protected ExpParam() {
        }
    }

    protected static class ExpMethod
    extends NutMap {
        private static final long serialVersionUID = 1L;

        protected ExpMethod() {
        }
    }

    protected static class ExpClass
    extends NutMap {
        private static final long serialVersionUID = 1L;

        protected ExpClass() {
        }
    }

    class DocActionInvoker
    extends ActionInvoker {
        DocActionInvoker() {
        }

        public boolean invoke(ActionContext ac) {
            try {
                ac.getResponse().setCharacterEncoding("UTF-8");
                NutMap re = new NutMap("data", infos);
                re.put((Object)"content_path", (Object)ac.getRequest().getContextPath());
                re.put((Object)"project", (Object)ApidocUrlMapping.this.projectInfo);
                ApidocUrlMapping.this.view.render(ac.getRequest(), ac.getResponse(), (Object)re);
            }
            catch (Throwable e) {
                log.debug((Object)"exp fail", e);
            }
            return true;
        }
    }

    class EmtryActionInvoker
    extends ActionInvoker {
        EmtryActionInvoker() {
        }

        public boolean invoke(ActionContext ac) {
            return true;
        }
    }
}

